/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __GLIB_RUNNABLE
#define __GLIB_RUNNABLE

#include "glib/primitives/GObject.h"

/**
 * A pure interface class that should be implemented by any class whose 
 * instances are intended to be executed by a {@link GThread}. The class 
 * must define a method of no arguments called {@link #run}, which will 
 * be called by the new thread when it is started.
 *
 * @author  Leif Erik Larsen
 * @since   2004.01.14
 */
class GRunnable
{
   public:

      /** This method will be called by the new thread when it is started. */
      virtual void run () = 0;
};

#endif


