/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/GProgramParameter.h"
#include "glib/GProgram.h"

GProgramParameter::GProgramParameter ( const GProgram& prg,
                                       const char* envName,
                                       const char* paramName,
                                       const char* defaultValue )
                  :prg(prg),
                   envName(envName),
                   paramName(paramName),
                   defaultValue(defaultValue)
{
}

GProgramParameter::~GProgramParameter ()
{
}

GString GProgramParameter::getValueAsString ( const GCmdLineParameters& params ) const
{
   GString val;
   if (paramName != "")
      val = params.getString(paramName, GString::Empty);
   if (val == "" && envName != "")
      val = prg.getEnvironmentVar(envName, GString::Empty);
   if (val == "")
      val = defaultValue;
   return val;
}
