/* localtim.c (emx+gcc) -- Copyright (c) 1990-1999 by Eberhard Mattes */

#include <time.h>
#include <emx/thread.h>
#include <emx/time.h>

struct tm *localtime (const time_t *t)
{
#if defined (__MT__)
  struct _thread *tp = _thread ();
#define result (tp->_th_gmtime_buf)
#else
  static struct tm result;
#endif
  return _localtime (&result, t);
}

struct tm *_localtime (struct tm *dst, const time_t *t)
{
  time_t lt;
  int isdst;
  struct tm *p;

  if (!_tzset_flag) _tzset ();
  lt = *t;
  isdst = _gmt2loc (&lt);
  p = _gmtime (dst, &lt);
  p->tm_isdst = isdst;
  return p;
}
