/* swab.c (emx+gcc) */

/* Regression test for swab(). */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static int errors;

static void error (int n)
{
  ++errors;
  fprintf (stderr, "Error %d\n", n);
}


int main (void)
{
  char buf[8];

  errors = 0;
  memset (buf, 'x', 8);
  swab ("abcd", buf, 4);
  if (memcmp (buf, "badcxxxx", 8) != 0)
    error (1);
  swab ("1234", buf, 3);
  if (memcmp (buf, "badcxxxx", 8) != 0)
    error (2);
  swab ("1234", buf, 0);
  if (memcmp (buf, "badcxxxx", 8) != 0)
    error (3);
  return errors;
}
