/* snprintf.c (emx+gcc) */

#include <assert.h>
#include <stdio.h>
#include <string.h>

int main (void)
{
  char buf[8];
  int i;

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, sizeof (buf), "%d", 17);
  assert (i == 2);
  assert (memcmp (buf, "17\0X", 4) == 0);

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, 7, "%d %s", 17, "Overflow");
  assert (i == 11);
  assert (memcmp (buf, "17 Ove\0X", 8) == 0);

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, sizeof (buf), "abcdefghijklmnopqrstuvwxyz");
  assert (i == 26);
  assert (memcmp (buf, "abcdefg", 8) == 0);

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, sizeof (buf), "abcdefg%c%c", 'h', 'i');
  assert (i == 9);
  assert (memcmp (buf, "abcdefg", 8) == 0);

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, sizeof (buf), "abcdef%s", "ghijklmnopqrstuvwxyz");
  assert (i == 26);
  assert (memcmp (buf, "abcdefg", 8) == 0);

  memset (buf, 'X', sizeof (buf));
  i = snprintf (buf, 0, "abcdef%s", "ghijklmnopqrstuvwxyz");
  assert (i == 26);
  assert (memcmp (buf, "XXXXXXXX", 8) == 0);

  i = snprintf (NULL, 0, "abcdef%s", "ghijklmnopqrstuvwxyz");
  assert (i == 26);

  return 0;
}
