/* forkexec.c (emx+gcc) */

/* 1276 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <process.h>

int main (int argc, char *argv[])
{
  if (argc == 2 && strcmp (argv[1], " eXeC ") == 0)
    {
      printf ("exec: pid = %d\n", getpid ());
      puts ("Note: The PID should not change on exec.  However, fixing that");
      puts ("      would cause other problems.  Still, wait() should report");
      puts ("      the correct PID.");
      puts ("Sleeping for 5 seconds...");
      sleep (5);
      puts ("exec: terminating");
    }
  else if (fork () == 0)
    {
      printf ("Child: pid = %d\n", getpid ());
      if (execl (argv[0], argv[0], " eXeC ", (char *)NULL) != 0)
        {
          perror ("execl()");
          return 1;
        }
    }
  else
    {
      int pid, st;

      while ((pid = wait (&st)) != -1)
        printf ("Process %d terminated\n", pid);
    }
  return 0;
}
