/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#if !defined ( CSTATS__UTILITY_FUNCTIONS___H )
#define CSTATS__UTILITY_FUNCTIONS___H 1

/* Function Prototypes */
signed long int FileSize( ifstream *file );
//int LoadBinFileRec( void *, long, long, ifstream * );
//int LoadBinFileRec( void *, size_t, size_t, ifstream * );
//template<class OBJ> int LoadBinFileRec( OBJ *, size_t, ifstream * )


char *strptoc( char *str );
char *ultoac( unsigned long int i );
char *sansirem( char *str );

template <class OBJ>
        int LoadBinFileRec( OBJ *object, size_t offset, ifstream *file )
{
        if ( file->is_open() )
        {
                file->seekg( ( long )( offset * sizeof( OBJ ) ), ios::beg );
                file->read( ( char * )object, sizeof( OBJ ) );
                if ( !file->gcount() )
                {
                        memset( ( void * )object, 0, sizeof( OBJ ) );
                        return ( 1 );
                }
                return ( 0 );
        }
        return ( 2 );
}

#endif
