/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <cerrno>
#include <cctype>
#include <ctime>
#include <cstring>

using namespace std;

#if defined( _MSC_VER )
# include <search.h>
#endif

#include "cstats.h"
#include "utilfunc.h"

signed long int FileSize( ifstream *file )
{
        signed long int curPos, lastPos;
        curPos = file->tellg();
        file->seekg( 0L, ios::end );
        lastPos = file->tellg();
        file->seekg( curPos, ios::beg );
        return ( lastPos );
}

//int LoadBinFileRec( void *object, size_t objSize, size_t offset, ifstream *file )

char *strptoc( char *str )
{
        int size = *str;
        memmove( str, &str[ 1 ], size );
        str[ size ] = '\0';
        return ( str );
}

/* ultoac() = unsigned long to ASCIIZ Commatized string */
char *ultoac( unsigned long int i )
{
        char *cint = ( char * )malloc( 20 * sizeof( char ) );
        if ( !cint )
                return ( NULL );

        memset( cint, 0, 20 * sizeof( char ) );

        if ( i >= 0L && i < 1000L )
                sprintf( cint, "%lu", i );
        else if ( i >= 1000L && i < 1000000L )
                sprintf( cint, "%lu,%03lu",
                        ( ( i / 1000L ) % 1000L ),
                        ( i % 1000L ) );
        else if ( i >= 1000000L && i < 1000000000L )
                sprintf( cint, "%lu,%03lu,%03lu",
                        ( ( i / 1000000L ) % 1000L ),
                        ( ( i / 1000L ) % 1000L ),
                        ( i % 1000L ) );
        else if ( i > 1000000000L )
                sprintf( cint, "%lu,%03lu,%03lu,%03lu",
                        ( ( i / 1000000000L ) % 1000L ),
                        ( ( i / 1000000L ) % 1000L ),
                        ( ( i / 1000L ) % 1000L ),
                        ( i % 1000L ) );

        return ( cint );
}


char *sansirem( char *str )
{
        char *ptr = str;
        char *chr;
        char *newstr = new char[ strlen( str ) + 5 ];
        char *nptr = newstr;
        memset( newstr, 0, strlen( str ) + 5 );
        do {
                if ( ( *ptr == '`' ) && ( chr = strchr( "0124356789!#@$%", *(ptr + 1) ) ) )
                        ++ptr;
                else
                        *nptr++ = *ptr;
        } while ( *++ptr );
        str[ 0 ] = '\0';
        strcpy( str, newstr );
        delete [] newstr;
        return ( str );
}

