/*
     Copyright (c) 2000,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
#include <iostream>
#include <fstream>
#include <iomanip>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>
#include <cerrno>

using namespace std;

#include "cstats.h"
#include "utilfunc.h"

/**************************************************************************
 * Avalon v0.85b
 *
 * Specific functions to handle Avalon
 **************************************************************************/
//int avln85DelChk( const void *player )
int avln85DelChk( avln_UserRecord *player )
{
        return ( 0 );
}

//void avln85Assign( SORT *psort, const void *object )
void avln85Assign( SORT *psort, avln_UserRecord *object )
{
//        psort->Experience = ( ( avln_UserRecord * )object )->Exp;
        psort->Experience = object->Exp;
}

int avln85Compare( const void *p1, const void *p2 )
{
        SORT *avlnSort1 = ( SORT * )p1, *avlnSort2 = ( SORT * )p2;
        if ( avlnSort1->Experience == avlnSort2->Experience )
                return ( 0 );
        if ( avlnSort1->Experience < avlnSort2->Experience )
                return ( 1 );
        else
                return ( -1 );
}

void avln85HTML( int task )
{
        const char szStatFile[] = "avlnstat.htm";
        const char statTitle[] = "Avalon - Live The Epic Player Statistics";
        ofstream   statFile;
        if ( task == 0 )
        {
                statFile.open( szStatFile );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                cout << "Writing the statistics to \"" << szStatFile << "\"..." << endl;
                htmlStatHeader( &statFile, statTitle );
                statFile << "<tr bgcolor=\"#606060\">" << endl;
                statFile << "<td width=\"5%\" algin=\"center\"><u>Sex</u></td>" << endl;              /* Gender     */
                statFile << "<td width=\"25%\" align=\"left\"><u>Character Alias</u></td>" << endl;   /* Name       */
                statFile << "<td width=\"20%\" align=\"right\"><u>Experience</u></td>" << endl;       /* Experience */
                statFile << "<td width=\"10%\" align=\"right\"><u>Level</u></td>" << endl;            /* Level      */
                statFile << "<td width=\"15%\" align=\"center\"><u>Time Zone</u></td>" << endl;       /* Time Zone  */
                statFile << "<td width=\"15%\" align=\"left\"><u>Companion</u></td>" << endl;         /* Companion  */
                statFile << "<td width=\"10%\" align=\"left\"><u>Skill</u></td>" << endl;             /* Skill      */
                statFile << "</tr>" << endl;
        }
        else
        {
                statFile.open( szStatFile, ios::app );
                if ( !statFile )
                {
                        cerr << "Unable to open " << szStatFile << " for output." << endl;
                        return;
                }
                htmlStatClose( &statFile );
        }
        statFile.close();
}

//void avln85Output( PRGSCAN *prgScan, const void *object )
void avln85Output( PRGSCAN *prgScan, avln_UserRecord *p )
{
        const char szStatFile[] = "avlnstat.htm";
        ofstream statFile( szStatFile, ios::app );
//        avln_UserRecord *p = ( avln_UserRecord * )object;
        if ( !statFile )
        {
                cerr << "Unable to open " << szStatFile << " for append/output." << endl;
                return;
        }
        statFile << "<tr bgcolor=\"#000000\">" << endl;
        /* Female or not? */
        statFile << "<td width=\"5%\" align=\"center\">" << endl;
        if ( p->Gender == 1 )
        {
                htmlSetColor( &statFile, 0x00a0d8L );
                statFile << "M" << "</font>" << endl;
        }
        else
        {
                htmlSetColor( &statFile, 0xd800d8L );
                statFile << "F" << "</font>" << endl;
        }
        statFile << "</td>" << endl;
        /* Name */
        statFile << "<td width=\"25%\" align=\"left\">" << endl;
        htmlSetColor( &statFile, 0x00c8c8L );
        statFile << strptoc( p->Alias ) << "</font></td>" << endl;
        /* Experience */
        statFile << "<td width=\"20%\" align=\"right\">" << endl;
        htmlSetColor( &statFile, 0x00c8c8L );
        statFile << ultoac( (unsigned)p->Exp ) << "</font></td>" << endl;
        /* Level */
        statFile << "<td width=\"10%\" align=\"right\">" << endl;
        htmlSetColor( &statFile, 0x00c8c8L );
        statFile << p->Level << "</font></td>" << endl;
        /* Time Zone */
        statFile << "<td width=\"15%\" align=\"center\">" << endl;
        switch ( p->Time_Zone )
        {
                case 1 : /* Medieval */
                         htmlSetColor( &statFile, 0xfa0000L );
                         statFile << "Medieval" << endl;
                         break;
                case 2 : /* Present */
                         htmlSetColor( &statFile, 0x00f000L );
                         statFile << "Present" << endl;
                         break;
                case 3 : /* Future */
                         htmlSetColor( &statFile, 0xf800f8L );
                         statFile << "Future" << endl;
                         break;
                case 4 : /* Avalon */
                         htmlSetColor( &statFile, 0x00c8ffL );
                         statFile << "Avalon" << endl;
                         break;
        }
        statFile << "</font></td>" << endl;
        /* Companion */
        statFile << "<td width=\"15%\" align=\"left\">" << endl;
        statFile << strptoc( p->Companion ) << "</td>" << endl;
        /* Skill */
        statFile << "<td width=\"10%\" align=\"left\">" << endl;
        switch ( p->Char_Class )
        {
                case 1 : /* Warrior */
                         htmlSetColor( &statFile, 0x00a0e8L );
                         statFile << "Warrior" << endl;
                         break;
                case 2 : /* Necromancer */
                         htmlSetColor( &statFile, 0x00e800L );
                         statFile << "Necromancer" << endl;
                         break;
                case 3 : /* Thief */
                         htmlSetColor( &statFile, 0xe80000L );
                         statFile << "Thief" << endl;
                         break;
        }
        statFile << "</font></td>" << endl;
        statFile << "</tr>" << endl;
        statFile.flush();
        statFile.close();
}


