/**********************************************************************
  Copyright (c) 2000-2002, Michael Dillon
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions 
  are met:

       Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer. 

       Redistributions in binary form must reproduce the above 
       copyright notice, this list of conditions and the following 
       disclaimer in the documentation and/or other materials provided 
       with the distribution. 

       Neither the name of Crystalline Realms, Midnight's Hour BBS,
       Elysium Software nor the names of their contributors may be 
       used to endorse or promote products derived from this software 
       without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/
/*********************************************************************
 CDirect.h - class for handling cross-platform directory searching.
 *********************************************************************/
#if !defined (__DIRECT__FILE_SEARCH___H)
#define __DIRECT__FILE_SEARCH___H 1

#ifndef __cplusplus
# error "This source REQUIRES C++ to function"
#endif

//#include <iostream>
//#include <string> // STL String header

#include "headers.h"
#include "tinytic.h" // This will define the system type we can use

//#ifndef __NAMESPACE_SET
//# if !defined(STLPORT) || defined(_STL_USE_NAMESPACES)
//    using namespace std ;
//# endif /* !STL_PORT || _STL_USE_NAMESPACES */
//# define __NAMESPACE_SET 1
//#endif /* __NAMESPACE_SET */

#include <sys/types.h> // Required for stat()
#include <sys/stat.h>  // Definition for stat()

// Check to see if the definitions are already set, if they are
// then undefine them.
// __DIRECT__FILE_SEARCH_WINDOWS  : Definition set for Windows based systems
// __DIRECT__FILE_SEARCH_POSIX    : Definition set for POSIX enabled systems

#undef __DIRECT__FILE_SEARCH_WINDOWS
#undef __DIRECT__FILE_SEARCH_POSIX
#undef __DIRECT__FILE_SEARCH_OS2

#if defined(__TINYTIC_WINDOWS)
# define __DIRECT__FILE_SEARCH_WINDOWS
# include <io.h>
# include <direct.h>
#elif defined(__TINYTIC_POSIX)
# define __DIRECT__FILE_SEARCH_POSIX
# include <dirent.h>
# include <fnmatch.h>
#elif defined(__TINYTIC_OS2)
# define __DIRECT__FILE_SEARCH_OS2
# include <io.h>
#else
# error "Please define the correct compiler type"
#endif

// Primary structure used by CDirect
typedef struct {
        unsigned short int      Mode;         // File's Mode settings
        time_t                  AccessTime;   // Last Access Time
        time_t                  CreateTime;   // File creation date
        time_t                  WriteTime;    // Last Write time
        unsigned long int       Size;         // Size of file
        char                    Name[4096];   // File's Name
} FileData;

class CDirect
{
public:
        CDirect();
        CDirect(const char *pattern, const char *directory = ".");
        ~CDirect();

        // Find: Calls on FindNext or FindFirst depending on if the
        //       directory has been opened.
        bool Find(void);
        // GetInfo: Returns the current FileData for any given file
        //          found.
        FileData GetInfo(void);
        // GetCount: Returns the number of files that matched the pattern
        //           in the given directory.
        unsigned long int GetCount(void) { return (_MaxFiles); }

private:
        // FindFirst: Searches for the first entry matching the given pattern
        bool FindFirst(void);
        // FindNext: Searches for the next relevant entry matching the given
        //           pattern
        bool FindNext(void);
        // ValidateData: Sets the values for the FileData structure
        void ValidateData(void);
        // DestroyValues: Clears the values for the FileData structure
        //                This is done before each call to FindNext and
        //                FindFirst
        void DestroyValues(void);
        // FixPath: Makes sure there is a trailing slash for the directory
        //          given
        void FixPath(void);
        // GetMaxFiles: Count the number of files matching the pattern in
        //              the directory.
        void GetMaxFiles(void);

        // hFileData: Internal FileData structure, this will be modified
        //            by ValidateData primarily, and sent to a requesting
        //            program by GetInfo
        FileData hFileData;
        // _pattern: Internal storage for the 'pattern' passed at
        //           construction time.
        string _pattern;
        // _directory: Internal storage for the 'directory' passed at
        //             construction time.
        string _directory;

        // _open: Internal flag to see if the directory is in access or
        //        was unable to be opened.
        bool _open;
        // hFStat: Structure used to gather info from stat() and put it
        //         in the hFileData structure
        struct stat hFStat;
        // _MaxFiles: Internal value that indicates how many files were
        //            found matching the pattern
        unsigned long int _MaxFiles;

#if defined(__DIRECT__FILE_SEARCH_WINDOWS) || defined(__DIRECT__FILE_SEARCH_OS2)
// --------------------------
// Windows & OS/2 Specific additions
// --------------------------
        // hFileSearch: Find handle passed by findfirst()
        long hFileSearch;
        // hFindData: Structure used by findfirst() and findnext()
        struct _finddata_t hFindData;
#elif defined(__DIRECT__FILE_SEARCH_POSIX)
// --------------------------
// POSIX Specific additions
// --------------------------
        // hDir: Directory handle passed from opendir()
        DIR *hDir;
        // hDirent: Passed from readdir(), holds the file that was found.
        struct dirent *hDirent;
#endif
};


#endif
