                            /
  0   
 U S A G E T X T         0           Syntax: RECURSE [options] [d:\]startdir command [args...]
        RECURSE @[d:\path\]filename

Purpose: Recurses a directory tree executing a command in each directory.

If the sole parameter to the program is a filename preceeded by an at-sign (@),
the various arguments will be read from the given text file one-per-line.  They
must be in the same order (options-startdir-command) as expected when provided
on the command line itself.  Any command arguments should be on separate lines.

Startdir is the directory to begin operations in.  UNC names and dot shortcuts 
(. and ..) are acceptable.

The command (along with any supplied arguments) will be executed in each 
directory processed, except where options dictate otherwise (see below).  The 
current directory will be set appropriately before issuing each command.  In 
addition, you can use the %dir% placeholder to have the current directory name 
placed into the command itself or any of its arguments.  Remember to quote
where needed.

The following options are available:

/showdir     Prints the name of each directory visited to standard output.

/showcmd     Prints each command issued (after %dir% replacment).

/test        Doesn't actually execute the command.  Useful when used with the
             "show" options.
             
/mindepth=#  Won't start issuing commands until the given nesting level is
             reached.  The starting directory has a depth of zero.

/maxdepth=#  Limits recursion to the given number of subdirectories below the
             starting directory.

/include=
/exclude=
/ignore=     Supply a semicolon-delimited list of directories to in/exclude.
             A filename with one name per line may be specified using a leading
             at-sign (@).  These are compared as substrings, so passing "temp"
             will match "c:\temp" or "c:\attempts".  Add surrounding 
             backslashes to limit the match to a complete directory name, e.g.
             "\temp\".

             Include will recurse the entire tree, but will only execute the 
             command in matching directories.  Both exclude and ignore will
             skip the command if a match is made, but ignore will also stop 
             recursing any further down the matching path.  If more than one of
             these options is specified, the precedence is ignore-exclude-
             include.  The /showdir option will display exactly what matched,
             if anything.

Example: RECURSE /mindepth=1 /exclude=@skip.txt c:\source touch "%dir%\*.pas"
                       (       @                                                                                                                UU   UU   UU   UUU   UU  UU\̀  UU  UU\  UU  UUU  UU  UUW  UU UUP UU UU UU UUU   UUUUX   UUUUP  UUUUUp  UUUUU  UUUUY  UUUUY UUUU UUy  UU  UUp y  UU  y  UU    UU    UUY   UU   	        	        	                                         A  x x <`<p>>??      0    M A I N I C O N         0                      