package jp.co.sra.smalltalk.menu;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;

import jp.co.sra.smalltalk.SmalltalkException;

/**
 * StRadioButtonMenuItemViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StRadioButtonMenuItemViewSwing.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StRadioButtonMenuItemViewSwing extends StCheckBoxMenuItemViewSwing implements StRadioButtonMenuItemView {

	/**
	 * Create a new instance of StRadioButtonMenuItemViewSwing and initialize it.
	 *
	 * @param aRadioButtonMenuItem jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category Instance creation
	 */
	public StRadioButtonMenuItemViewSwing(StRadioButtonMenuItem aRadioButtonMenuItem) {
		super(aRadioButtonMenuItem);
	}

	/**
	 * Answer my radio button menu item.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @see jp.co.sra.smalltalk.menu.StRadioButtonMenuItemView#getRadioButtonMenuItem()
	 * @category model accessing
	 */
	public StRadioButtonMenuItem getRadioButtonMenuItem() {
		return (StRadioButtonMenuItem) this.getMenuItem();
	}

	/**
	 * Answer the menu item view as JCheckBoxMenuItem.
	 * 
	 * @return javax.swing.JCheckBoxMenuItem
	 * @see jp.co.sra.smalltalk.menu.StCheckBoxMenuItemViewSwing#toCheckBoxMenuItem()
	 * @category converting
	 */
	public JCheckBoxMenuItem toCheckBoxMenuItem() {
		throw SmalltalkException.Error("cannot be JCheckBoxMeneItem");
	}

	/**
	 * Answer the menu item view as JCheckBoxMenuItem.
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 * @category converting
	 */
	public JRadioButtonMenuItem toRadioButtonMenuItem() {
		return (JRadioButtonMenuItem) this.menuItemView();
	}

	/**
	 * Update the selection status.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StCheckBoxMenuItemViewSwing#updateSelection()
	 * @category updating
	 */
	protected void updateSelection() {
		boolean isSelected = this.getRadioButtonMenuItem().isSelected();
		if (this.toRadioButtonMenuItem().isSelected() != isSelected) {
			this.toRadioButtonMenuItem().setSelected(isSelected);
		}
	}

	/**
	 * Create a menu item view.
	 * 
	 * @return javax.swing.JComponent
	 * @see jp.co.sra.smalltalk.menu.StMenuItemViewSwing#createMenuItemView()
	 * @category private
	 */
	protected JComponent createMenuItemView() {
		JRadioButtonMenuItem aRadioButtonMenuItem = new JRadioButtonMenuItem();
		aRadioButtonMenuItem.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				StRadioButtonMenuItemViewSwing aRadioButtonMenuItemView = StRadioButtonMenuItemViewSwing.this;
				if (e.getStateChange() == ItemEvent.SELECTED) {
					if (aRadioButtonMenuItemView.getCheckBoxMenuItem().isSelected() == false) {
						aRadioButtonMenuItemView.getCheckBoxMenuItem().beOn();
						aRadioButtonMenuItemView.performMenu($("selection"), e);
					}
				} else {
					aRadioButtonMenuItemView.updateSelection(); // to set the check mark.
					// notify the change?
				}
			}
		});
		return aRadioButtonMenuItem;
	}

}