package jp.co.sra.smalltalk.menu;

import java.util.ArrayList;

import jp.co.sra.smalltalk.StSymbol;

/**
 * StRadioButtonGroup class
 * 
 *  @author    nisinaka
 *  @created   2005/02/18 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StRadioButtonGroup.java,v 8.10 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StRadioButtonGroup extends StAbstractMenuItem {

	protected static final StRadioButtonGroup DefaultGroup = new StRadioButtonGroup();

	protected ArrayList buttons;
	protected StRadioButtonMenuItem selectedButton;

	/**
	 * Create a new instance of StRadioButtonGroup and initialize it.
	 *
	 * @category Instance creation
	 */
	public StRadioButtonGroup() {
		this.buttons = new ArrayList();
		this.selectedButton = null;
	}

	/**
	 * Create a new instance of StRadioButtonGroup and initialize it.
	 *
	 * @param radioButtons jp.co.sra.smalltalk.menu.StRadioButtonMenuItem[]
	 * @category Instance creation
	 */
	public StRadioButtonGroup(StRadioButtonMenuItem[] radioButtons) {
		this();

		for (int i = 0; i < radioButtons.length; i++) {
			radioButtons[i].group_(this);
		}
	}

	/**
	 * Answer my currently selected button.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category accessing
	 */
	public StRadioButtonMenuItem selectedButton() {
		return selectedButton;
	}

	/**
	 * Add the specified StRadioButtonMenuItem to the receiver's group.
	 * 
	 * @param aRadioButtonMenuItem jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category adding
	 */
	public synchronized void add(StRadioButtonMenuItem aRadioButtonMenuItem) {
		buttons.add(aRadioButtonMenuItem);
	}

	/**
	 * Remove the specified StRadioButtonMenuItem to the receiver's group.
	 * 
	 * @param aRadioButtonMenuItem jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category removing
	 */
	public synchronized void remove(StRadioButtonMenuItem aRadioButtonMenuItem) {
		buttons.remove(aRadioButtonMenuItem);
	}

	/**
	 * Select the specified StRadioButtonMenuItem.
	 * 
	 * @param aRadioButtonMenuItem jp.co.sra.smalltalk.menu.StRadioButtonMenuItem
	 * @category selecting
	 */
	public synchronized void select(StRadioButtonMenuItem aRadioButtonMenuItem) {
		if (buttons.contains(aRadioButtonMenuItem) == false) {
			return;
		}
		if (selectedButton == aRadioButtonMenuItem) {
			return;
		}

		if (selectedButton != null) {
			selectedButton.beOff();
		}

		selectedButton = aRadioButtonMenuItem;

		if (selectedButton != null) {
			selectedButton.beOn();
		}
	}

	/**
	 * Answer my menu items.
	 * 
	 * @return java.util.ArrayList
	 * @category menu items
	 */
	public synchronized StMenuItem[] menuItems() {
		return (StMenuItem[]) buttons.toArray(new StMenuItem[buttons.size()]);
	}

	/**
	 * Answer the StRadioButtonGroup with the specified name.
	 * If not exist, create one.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @deprecated since StPL7.0rc4, do manage groups by instance, not by name.
	 * @category Accessing
	 */
	public static StRadioButtonGroup Named(StSymbol aSymbol) {
		return new StRadioButtonGroup();
	}

	/**
	 * Answer the StRadioButtonGroup with the specified name.
	 * The radio buttons will be added to the group.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @param radioButtons jp.co.sra.smalltalk.menu.StRadioButtonMenuItem[]
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @deprecated since StPL7.0rc4, do manage groups by instance, not by name.
	 * @category Accessing
	 */
	public static StRadioButtonGroup Named(StSymbol aSymbol, StRadioButtonMenuItem[] radioButtons) {
		StRadioButtonGroup aRadioButtonGroup = Named(aSymbol);

		if (radioButtons != null) {
			for (int i = 0; i < radioButtons.length; i++) {
				aRadioButtonGroup.add(radioButtons[i]);
			}
		}

		return aRadioButtonGroup;
	}

	/**
	 * Answer my name.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @deprecated since StPL7.0rc4, do manage groups by instance, not by name.
	 * @category accessing
	 */
	public StSymbol name() {
		return null;
	}

}