package jp.co.sra.smalltalk.menu;

import jp.co.sra.smalltalk.StApplicationModel;

/**
 * StPopupMenu class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StPopupMenu.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StPopupMenu extends StMenu {

	/**
	 * Create a new instance of StPopupMenu.
	 * 
	 * @category Instance creation
	 */
	public StPopupMenu() {
		this("");
	}

	/**
	 * Create a new instance of StPopupMenu and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	private StPopupMenu(Object label) {
		super(label);
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category interface opening
	 */
	public StMenuItemView defaultView() {
		if (StApplicationModel.GetDefaultViewMode() == StApplicationModel.VIEW_AWT) {
			return new StPopupMenuViewAwt(this);
		} else {
			return new StPopupMenuViewSwing(this);
		}
	}

}