package jp.co.sra.smalltalk.menu;

import jp.co.sra.smalltalk.StSymbol;

/**
 * StMenuView interface
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenuView.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public interface StMenuView extends StMenuItemView {

	/**
	 * Answer my menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @category model accessing
	 */
	public StMenu getMenu();

	/**
	 * Answer the menu item view associated with the given name key (or null if none).
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category menu items-name keys
	 */
	public StMenuItemView atNameKey_(StSymbol aSymbol);

}
