package jp.co.sra.smalltalk.menu;

import java.util.ArrayList;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StSymbol;

/**
 * StMenu class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StMenu.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StMenu extends StMenuItem {

	protected ArrayList items = new ArrayList();

	public static StMenuItem Separator = new StMenuItem(null);

	/**
	 * Create a new instance of StMenu and initialize it.
	 *
	 * @category Instance creation
	 */
	public StMenu() {
		super(null);
	}

	/**
	 * Create a new instance of StMenu and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	public StMenu(Object label) {
		super(label);
	}

	/**
	 * Create a new instance of StMenu and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public StMenu(Object label, StSymbol nameKey) {
		super(label, nameKey);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItem#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		items = new ArrayList();
	}

	/**
	 * Answer my menu items.
	 * 
	 * @return java.util.ArrayList
	 * @category menu items
	 */
	public StMenuItem[] menuItems() {
		return (StMenuItem[]) items.toArray(new StMenuItem[items.size()]);
	}

	/**
	 * Answer the integer index of the given menu item.
	 * The first menu item would have an index of 0.
	 * If the receiver does	not contain the menu item, answer -1.
	 * 
	 * @param aMenuItem jp.co.sra.smalltalk.menu.StMenuItem
	 * @return int
	 * @category menu items
	 */
	public int indexOf(StMenuItem aMenuItem) {
		return items.indexOf(aMenuItem);
	}

	/**
	 * Answer the MenuItem in the receiver at the given index.
	 * The first menu item would have an index of 1.
	 * 
	 * @param index int
	 * @return jp.co.sra.smalltalk.menu.StMenuItem
	 * @category menu items
	 */
	public StMenuItem at(int index) {
		return (StMenuItem) items.get(index);
	}

	/**
	 * Add a new menu item to the end of the menu.
	 * 
	 * @param aMenuItem jp.co.sra.smalltalk.menu.StMenuItem
	 * @category menu items-adding
	 */
	public void add(StMenuItem aMenuItem) {
		if (aMenuItem != null) {
			items.add(aMenuItem);
		}
	}

	/**
	 * Add a separator to the end of the menu.
	 * 
	 * @category menu items-adding
	 */
	public void addSeparator() {
		this.add(Separator);
	}

	/**
	 * Add all menu items.
	 * 
	 * @param menuItems jp.co.sra.smalltalk.meu.StMenuItem[]
	 * @category menu items-adding
	 */
	public void addAll(StMenuItem[] menuItems) {
		if (menuItems != null) {
			for (int i = 0; i < menuItems.length; i++) {
				this.add(menuItems[i]);
			}
		}
	}

	/**
	 * Remove the MenuItem from the menu.
	 * The menu item group to which it belongs will have one less item.
	 * 
	 * @param aMenuItem jp.co.sra.smalltalk.meu.StMenuItem
	 * @category menu items-removing
	 */
	public void remove(StMenuItem aMenuItem) {
		items.remove(aMenuItem);
	}

	/**
	 * Remove all menu items.
	 * 
	 * @category menu items-removing
	 */
	public void removeAll() {
		items.clear();
	}

	/**
	 * Answer the menu item associated with the given name key (or null if none).
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * @return jp.co.sra.smalltalk.menu.StMenuItem
	 * @category menu items-name keys
	 */
	public StMenuItem atNameKey_(StSymbol aSymbol) {
		StMenuItem[] items = this.menuItems();
		for (int i = 0; i < items.length; i++) {
			if (items[i] == Separator) {
				// skip 
			} else if (items[i].nameKey() == aSymbol) {
				return items[i];
			} else if (items[i] instanceof StMenu) {
				StMenuItem aMenuItem = ((StMenu) items[i]).atNameKey_(aSymbol);
				if (aMenuItem != null) {
					return aMenuItem;
				}
			}
		}
		return null;
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category interface opening
	 */
	public StMenuItemView defaultView() {
		if (StApplicationModel.GetDefaultViewMode() == StApplicationModel.VIEW_AWT) {
			return new StMenuViewAwt(this);
		} else {
			return new StMenuViewSwing(this);
		}
	}

	/**
	 * Reset the label.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItem#resetAllLabels()
	 * @category resetting
	 */
	public void resetAllLabels() {
		super.resetAllLabels();

		StMenuItem[] items = this.menuItems();
		for (int i = 0; i < items.length; i++) {
			items[i].resetAllLabels();
		}
	}
}