package jp.co.sra.smalltalk.menu;

import jp.co.sra.smalltalk.StObject;

/**
 * MenuPerformer class
 * 
 *  @author    nisinaka
 *  @created   2005/02/24 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: MenuPerformer.java,v 8.11 2008/02/20 06:33:36 nisinaka Exp $
 */
public class MenuPerformer extends MenuDispatcher {

	/**
	 * Create a new instance of MenuPerformer and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @category Instance creation
	 */
	public MenuPerformer(StObject receiver, String selector) {
		super(receiver, selector);
	}

	/**
	 * Create a new instance of MenuPerformer and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @param argument java.lang.Object
	 * @category Instance creation
	 */
	public MenuPerformer(StObject receiver, String selector, Object argument) {
		super(receiver, selector, argument);
	}

	/**
	 * Create a new instance of MenuPerformer and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 * @category Instance creation
	 */
	public MenuPerformer(StObject receiver, String selector, Object[] arguments) {
		super(receiver, selector, arguments);
	}

	/**
	 * The menu is performed with the menu event.
	 * 
	 * @param aMenuEvent jp.co.sra.smalltalk.menu.MenuEvent
	 * @see jp.co.sra.smalltalk.menu.MenuListener#menuPerformed(jp.co.sra.smalltalk.menu.MenuEvent)
	 * @category event handling
	 */
	public void menuPerformed(final MenuEvent aMenuEvent) {
		Thread aThread = new Thread() {
			public void run() {
				MenuPerformer.super.menuPerformed(aMenuEvent);
			}
		};
		aThread.start();
	}

}