package jp.co.sra.smalltalk.menu;

import java.lang.reflect.InvocationTargetException;

import jp.co.sra.smalltalk.StObject;

/**
 * MenuDispatcher class
 * 
 *  @author    nisinaka
 *  @created   2006/12/13 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: MenuDispatcher.java,v 8.8 2008/02/20 06:33:36 nisinaka Exp $
 */
public class MenuDispatcher implements MenuListener {

	protected StObject receiver;
	protected String selector;
	protected Object[] arguments;

	/**
	 * Create a new instance of MenuDispatcher and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @category Instance creation
	 */
	public MenuDispatcher(StObject receiver, String selector) {
		this(receiver, selector, null);
	}

	/**
	 * Create a new instance of MenuDispatcher and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @param argument java.lang.Object
	 * @category Instance creation
	 */
	public MenuDispatcher(StObject receiver, String selector, Object argument) {
		this(receiver, selector, new Object[] { argument });
	}

	/**
	 * Create a new instance of MenuDispatcher and initialize it.
	 *
	 * @param receiver jp.co.sra.smalltalk.StObject
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 * @category Instance creation
	 */
	public MenuDispatcher(StObject receiver, String selector, Object[] arguments) {
		this.receiver = receiver;
		this.selector = selector;
		this.arguments = arguments;
	}

	/**
	 * The menu is performed with the menu event.
	 * 
	 * @param aMenuEvent jp.co.sra.smalltalk.menu.MenuEvent
	 * @see jp.co.sra.smalltalk.menu.MenuListener#menuPerformed(jp.co.sra.smalltalk.menu.MenuEvent)
	 * @category event handling
	 */
	public void menuPerformed(MenuEvent aMenuEvent) {
		try {
			this.action();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Perform the menu action.
	 * 
	 * @throws IllegalArgumentException
	 * @throws NoSuchMethodException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 * @category private
	 */
	protected void action() throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
		if (receiver == null || selector == null) {
			return;
		}
		if (arguments == null) {
			receiver.perform_(selector);
		} else {
			receiver.perform_withArguments_(selector, arguments);
		}
	}
}
