package jp.co.sra.smalltalk;

import javax.swing.JPopupMenu;

/**
 * StViewSwing interface
 * 
 *  @author    nisinaka
 *  @created   2005/02/24 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StViewSwing.java,v 8.9 2008/02/20 06:33:18 nisinaka Exp $
 */
public interface StViewSwing extends StView {

	/**
	 * Answer my popup menu view.
	 *
	 * @return javax.swing.JPopupMenu
	 * @category popup menu
	 */
	public JPopupMenu popupMenuView();

	/**
	 * Set my popup menu view.
	 * 
	 * @param aPopupMenu javax.swing.JPopupMenu
	 * @category popup menu
	 */
	public void popupMenuView_(JPopupMenu aPopupMenu);

	/**
	 * Answer true if a menu is specified to be a light weight one.
	 * 
	 * @return boolean
	 * @category popup menu
	 */
	public boolean isLightWeightPopupEnabled();

	/**
	 * Set whether a menu is created as a light weight one or not.
	 * 
	 * @param aFlag boolean
	 * @category popup menu
	 */
	public void setLightWeightPopupEnabled(boolean aFlag);

}