package jp.co.sra.smalltalk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/**
 * StUserMessageTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2005/03/09 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StUserMessageTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StUserMessageTestExamples extends SmalltalkTestExamples {

	protected static StMessageCatalog SampleMessageCatalog2 = StMessageCatalog.With(SampleResourceBundle2());
	protected static StMessageCatalog SampleMessageCatalog1 = StMessageCatalog.With(SampleResourceBundle1());
	protected static StMessageCatalog NullMessageCatalog = StMessageCatalog.With((ResourceBundle) null);

	/**
	 * The usage of StUserMessage.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		System.out.print("-- ");
		for (int i = 0; i < StMessageCatalog.Catalogs.size(); i++) {
			StMessageCatalog aMessageCatalog = (StMessageCatalog) StMessageCatalog.Catalogs.get(i);
			if (aMessageCatalog == NullMessageCatalog) {
				System.out.print("NullMessageCatalog");
			} else if (aMessageCatalog == SampleMessageCatalog1) {
				System.out.print("SampleMessageCatalog1");
			} else if (aMessageCatalog == SampleMessageCatalog2) {
				System.out.print("SampleMessageCatalog2");
			}
			System.out.print(", ");
		}
		System.out.println();

		System.out.println("aoki -> " + new StUserMessage("aoki").asString());
		System.out.println("aoki -> " + new StUserMessage("aoki", "AOKI", NullMessageCatalog).asString());
		System.out.println("nisinaka <1p> -> " + new StUserMessage("nisinaka <1p>").expandMacrosWith(new StUserMessage("yoshiyuki").asString()));
		System.out.println("undefined -> " + new StUserMessage("undefined").asString());
		System.out.println("undefined -> " + new StUserMessage("undefined", "UNDEFINED").asString());
		return true;
	}

	/**
	 * Change the priority of the message catalogs.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		StMessageCatalog.GivePriorityTo(SampleMessageCatalog2);
		Example1();

		return true;
	}

	/**
	 * The usage of the utility method defined in StObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		System.out.println("<1p> is <2p>. -> " + $String("<1p> is <2p>.", null, new String[] { "This", "a pen" }));
		return true;
	}

	/**
	 * A sample resource bundle.
	 * 
	 * @return java.util.ResourceBundle
	 * @category Resources
	 */
	protected static ResourceBundle SampleResourceBundle1() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("aoki=\\u9752\\u6728 \\u6df3");
		pw.println("nisinaka\\ <1p>=\\u897f\\u4e2d <1p>");
		pw.println("yoshiyuki=\\u82b3\\u5e78");

		InputStream stream = new ByteArrayInputStream(sw.toString().getBytes());

		ResourceBundle aResourceBundle = null;
		try {
			aResourceBundle = new PropertyResourceBundle(stream);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return aResourceBundle;
	}

	/**
	 * A sample resource bundle.
	 * 
	 * @return java.util.ResourceBundle
	 * @category Resources
	 */
	protected static ResourceBundle SampleResourceBundle2() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("aoki=The Smalltalker");
		pw.println("nisinaka\\ <1p>=NISHINAKA <1p>");

		InputStream stream = new ByteArrayInputStream(sw.toString().getBytes());

		ResourceBundle aResourceBundle = null;
		try {
			aResourceBundle = new PropertyResourceBundle(stream);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return aResourceBundle;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StUserMessageTestExamples();
	}

}
