package jp.co.sra.smalltalk;

/**
 * StSymbolTestExamples class
 * 
 *  @author    He Weijie
 *  @created   1998/10/09 (by He Weijie)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSymbolTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSymbolTestExamples extends SmalltalkTestExamples {

	/**
	 * The usage of StSymbol().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		try {
			StSymbol aSymbol = StSymbol.Intern_("test");

			System.out.println("value = " + aSymbol + " size = " + aSymbol.size());
			aSymbol = StSymbol.Intern_("test1");
			System.out.println("value = " + aSymbol + " size = " + aSymbol.size());

			StSymbol anotherSymbol = StSymbol.Intern_("test1");

			System.out.println("value = " + anotherSymbol + " size = " + anotherSymbol.size());

			return aSymbol == anotherSymbol;
		} catch (Exception e) {
			return false;
		}
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StSymbolTestExamples();
	}
}
