package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * StSimpleDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/03/17 (by nisinaka)
 *  @updated   2007/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSimpleDialogViewSwing.java,v 8.13 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSimpleDialogViewSwing extends StViewJPanel implements StSimpleDialogView {

	protected JButton defaultButton;

	/**
	 * Create a new instance of StSimpleDialogViewSwing and initialize it.
	 *
	 * @param aSimpleDialog jp.co.sra.smalltalk.StSimpleDialog
	 * @category Instance creation
	 */
	public StSimpleDialogViewSwing(StSimpleDialog aSimpleDialog) {
		super(aSimpleDialog);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		defaultButton = null;
	}

	/**
	 * Initialize and build the components for choosing.
	 *
	 * @param messageString java.lang.String
	 * @param labels java.lang.String[]
	 * @param values java.lang.Object[]
	 * @param defaultValue java.lang.Object
	 * @param result jp.co.sra.smalltalk.StValueHolder
	 * @param eqBoolean boolean
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToChoose(java.lang.String, java.lang.String[], java.lang.Object[], java.lang.Object, jp.co.sra.smalltalk.StValueHolder, boolean)
	 * @category initialize-release
	 */
	public void _initializeToChoose(final String messageString, String[] labels, Object[] values, Object defaultValue, final StValueHolder result, boolean eqBoolean) {
		this.removeAll();

		JPanel messageCanvas = new JPanel() {
			StComposedText composedText = new StComposedText(messageString);

			public Dimension getPreferredSize() {
				return composedText.extent();
			}

			public void paint(Graphics g) {
				super.paint(g);
				g.setColor(Color.black);
				int x = (this.getWidth() - composedText.width()) / 2;
				int y = (this.getHeight() - composedText.height()) / 2;
				composedText.displayOn_at_(g, new Point(x, y));
			}
		};

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout());
		for (int i = 0; i < labels.length; i++) {
			JButton aButton = new JButton(labels[i]);
			final Object value = values[i];
			if (defaultValue == null) {
				if (value == null) {
					defaultButton = aButton;
				}
			} else if (defaultValue.equals(value)) {
				defaultButton = aButton;
			}
			aButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					result.value_(value);
					getSimpleDialog().close();
				}
			});
			buttonPanel.add(aButton);
		}

		this.setLayout(new GridLayout(2, 1));
		this.add(messageCanvas);
		this.add(buttonPanel);
	}

	/**
	 * Initialize and build the components for choosing from the list.
	 * 
	 * @param messageString java.lang.String
	 * @param list java.lang.String[]
	 * @param listValues java.lang.Object[]
	 * @param buttons java.lang.String[]
	 * @param buttonValues java.lang.Object[]
	 * @param maxLines int
	 * @param result jp.co.sra.smalltalk.StValueHolder
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToChooseFromList(java.lang.String, java.lang.String[], java.lang.Object[], java.lang.String[], java.lang.Object[], int, jp.co.sra.smalltalk.StValueHolder)
	 * @category initialize-release
	 */
	public void _initializeToChooseFromList(String messageString, String[] list, Object[] listValues, String[] buttons, final Object[] buttonValues, int maxLines, final StValueHolder result) {
		this.removeAll();

		// list to choose
		final JList selectionList = new JList(list);
		selectionList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		selectionList.setVisibleRowCount(maxLines);
		selectionList.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if (e.getValueIsAdjusting()) {
					return;
				}
				result.value_(((JList) e.getSource()).getSelectedIndex());
			}
		});

		// accept/cancel buttons
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout());
		JButton acceptButton = new JButton(this.getSimpleDialog()._acceptButtonLabelString());
		acceptButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (selectionList.isSelectionEmpty()) {
					return;
				}
				getSimpleDialog().accept().value_(true);
			}
		});
		buttonPanel.add(acceptButton);
		JButton cancelButton = new JButton(this.getSimpleDialog()._cancelButtonLabelString());
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().cancel().value_(true);
			}
		});
		buttonPanel.add(cancelButton);

		// The panel at the bottom.
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new BoxLayout(bottomPanel, BoxLayout.PAGE_AXIS));
		bottomPanel.add(buttonPanel);

		if (buttons != null && buttons.length > 0) {
			JPanel buttonsPanel = new JPanel();
			buttonsPanel.setLayout(new FlowLayout());
			for (int i = 0; i < buttons.length; i++) {
				final Object buttonValue = buttonValues[i];
				JButton aButton = new JButton(buttons[i]);
				aButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						result.value_(buttonValue);
						getSimpleDialog().close();
					}
				});
				buttonsPanel.add(aButton);
			}

			bottomPanel.add(Box.createRigidArea(new Dimension(0, 10)));
			bottomPanel.add(buttonsPanel);
		}

		// layouting
		this.setLayout(new BorderLayout(5, 5));
		this.add(new JLabel(messageString, JLabel.CENTER), BorderLayout.PAGE_START);
		this.add(new JScrollPane(selectionList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);
		this.add(bottomPanel, BorderLayout.PAGE_END);

		defaultButton = acceptButton;
	}

	/**
	 * Initialize and build the components for requesting.
	 *
	 * @param messageString java.lang.String
	 * @param answerStringValue jp.co.sra.smalltalk.StValueHolder
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToRequest(java.lang.String, jp.co.sra.smalltalk.StValueHolder)
	 * @category initialize-release
	 */
	public void _initializeToRequest(final String messageString, final StValueHolder answerStringValue) {
		this.removeAll();

		JPanel messageCanvas = new JPanel() {
			StComposedText composedText = new StComposedText(messageString);

			public Dimension getPreferredSize() {
				return composedText.extent();
			}

			public void paint(Graphics g) {
				super.paint(g);
				g.setColor(Color.black);
				int x = (this.getWidth() - composedText.width()) / 2;
				int y = (this.getHeight() - composedText.height()) / 2;
				composedText.displayOn_at_(g, new Point(x, y));
			}
		};

		final JTextField textField = new JTextField((String) answerStringValue.value()) {
			public Dimension getPreferredSize() {
				return new Dimension(200, this.getFont().getSize());
			}
		};
		textField.addCaretListener(new CaretListener() {
			public void caretUpdate(CaretEvent e) {
				String newText = textField.getText();
				if (newText.equals(answerStringValue.value()) == false) {
					answerStringValue.value_(newText);
				}
			}
		});

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout());
		JButton acceptButton = new JButton(this.getSimpleDialog()._acceptButtonLabelString());
		acceptButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().accept().value_(true);
			}
		});
		buttonPanel.add(acceptButton);
		JButton cancelButton = new JButton(this.getSimpleDialog()._cancelButtonLabelString());
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().cancel().value_(true);
			}
		});
		buttonPanel.add(cancelButton);
		defaultButton = acceptButton;

		this.setLayout(new GridLayout(3, 1));
		this.add(messageCanvas);
		this.add(textField);
		this.add(buttonPanel);
	}

	/**
	 * Answer my model as StSimpleDialog.
	 *
	 * @return jp.co.sra.smalltalk.StSimpleDialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#getSimpleDialog()
	 * @category model accessing
	 */
	public StSimpleDialog getSimpleDialog() {
		return (StSimpleDialog) this.model();
	}

	/**
	 * Create a default dialog.
	 *
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog()
	 * @category defaults
	 */
	public Dialog defaultDialog() {
		return this.defaultDialog(null);
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog(java.awt.Component)
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull) {
		return this.defaultDialog(aComponentOrNull, false);
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @param undecorated boolean
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog(java.awt.Component, boolean)
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull, boolean undecorated) {
		Window parentWindow = this.defaultParentWindow(aComponentOrNull);
		JDialog aDialog = null;
		if (parentWindow instanceof Frame) {
			aDialog = new JDialog((Frame) parentWindow, this.getSimpleDialog().windowTitle(), true);
		} else if (parentWindow instanceof Dialog) {
			aDialog = new JDialog((Dialog) parentWindow, this.getSimpleDialog().windowTitle(), true);
		} else {
			aDialog = new JDialog((Frame) null, this.getSimpleDialog().windowTitle(), true);
		}
		aDialog.setUndecorated(undecorated);
		aDialog.getContentPane().add(this);
		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer the default parent window.
	 * 
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Window
	 * @category defaults
	 */
	protected Window defaultParentWindow(Component aComponentOrNull) {
		return StSimpleDialog.DefaultParentWindow(aComponentOrNull);
	}

	/**
	 * The view is realized, so gives the focus to the default button.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();

		// Gives the initial focus to the default button.
		this.topComponent().addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				super.windowOpened(e);

				if (defaultButton != null) {
					defaultButton.requestFocus();
				}
			}
		});
	}

}
