package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.Box;
import javax.swing.BoxLayout;

/**
 * StSimpleDialogViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/17 (by nisinaka)
 *  @updated   2007/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSimpleDialogViewAwt.java,v 8.14 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSimpleDialogViewAwt extends StViewPanel implements StSimpleDialogView {

	protected Button defaultButton;

	/**
	 * Create a new instance of StSimpleDialogViewAwt and initialize it.
	 *
	 * @param aSimpleDialog jp.co.sra.smalltalk.StSimpleDialog
	 * @category Instance creation
	 */
	public StSimpleDialogViewAwt(StSimpleDialog aSimpleDialog) {
		super(aSimpleDialog);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		defaultButton = null;
	}

	/**
	 * Initialize and build the components for choosing.
	 *
	 * @param messageString java.lang.String
	 * @param labels java.lang.String[]
	 * @param values java.lang.Object[]
	 * @param defaultValue java.lang.Object
	 * @param result jp.co.sra.smalltalk.StValueHolder
	 * @param eqBoolean boolean
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToChoose(java.lang.String, java.lang.String[], java.lang.Object[], java.lang.Object, jp.co.sra.smalltalk.StValueHolder, boolean)
	 * @category initialize-release
	 */
	public void _initializeToChoose(final String messageString, String[] labels, Object[] values, Object defaultValue, final StValueHolder result, boolean eqBoolean) {
		this.removeAll();

		Canvas messageCanvas = new Canvas() {
			StComposedText composedText = new StComposedText(messageString);

			public Dimension getPreferredSize() {
				return composedText.extent();
			}

			public void paint(Graphics g) {
				super.paint(g);
				g.setColor(Color.black);
				int x = (this.getWidth() - composedText.width()) / 2;
				int y = (this.getHeight() - composedText.height()) / 2;
				composedText.displayOn_at_(g, new Point(x, y));
			}
		};

		Panel buttonPanel = new Panel();
		buttonPanel.setLayout(new FlowLayout());
		for (int i = 0; i < labels.length; i++) {
			Button aButton = new Button(labels[i]);
			final Object value = values[i];
			if (defaultValue == null) {
				if (value == null) {
					defaultButton = aButton;
				}
			} else if (defaultValue.equals(value)) {
				defaultButton = aButton;
			}
			aButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					result.value_(value);
					getSimpleDialog().close();
				}
			});
			buttonPanel.add(aButton);
		}

		this.setLayout(new GridLayout(2, 1));
		this.add(messageCanvas);
		this.add(buttonPanel);
	}

	/**
	 * Initialize and build the components for choosing from the list.
	 * 
	 * @param messageString java.lang.String
	 * @param list java.lang.String[]
	 * @param listValues java.lang.Object[]
	 * @param buttons java.lang.String[]
	 * @param buttonValues java.lang.Object[]
	 * @param maxLines int
	 * @param result jp.co.sra.smalltalk.StValueHolder
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToChooseFromList(java.lang.String, java.lang.String[], java.lang.Object[], java.lang.String[], java.lang.Object[], int, jp.co.sra.smalltalk.StValueHolder)
	 * @category initialize-release
	 */
	public void _initializeToChooseFromList(String messageString, String[] list, Object[] listValues, String[] buttons, Object[] buttonValues, int maxLines, final StValueHolder result) {
		this.removeAll();

		// list to choose
		final List selectionList = new List(maxLines, false);
		for (int i = 0; i < list.length; i++) {
			selectionList.add(list[i]);
		}
		selectionList.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				result.value_(selectionList.getSelectedIndex());
			}
		});

		// accept/cancel buttons
		Panel buttonPanel = new Panel();
		buttonPanel.setLayout(new FlowLayout());
		Button acceptButton = new Button(this.getSimpleDialog()._acceptButtonLabelString());
		acceptButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (selectionList.getSelectedIndex() < 0) {
					return;
				}
				getSimpleDialog().accept().value_(true);
			}
		});
		buttonPanel.add(acceptButton);
		Button cancelButton = new Button(this.getSimpleDialog()._cancelButtonLabelString());
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().cancel().value_(true);
			}
		});
		buttonPanel.add(cancelButton);

		// The panel at the bottom.
		Panel bottomPanel = new Panel();
		bottomPanel.setLayout(new BoxLayout(bottomPanel, BoxLayout.PAGE_AXIS));
		bottomPanel.add(buttonPanel);

		if (buttons != null && buttons.length > 0) {
			Panel buttonsPanel = new Panel();
			buttonsPanel.setLayout(new FlowLayout());
			for (int i = 0; i < buttons.length; i++) {
				final Object buttonValue = buttonValues[i];
				Button aButton = new Button(buttons[i]);
				aButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						result.value_(buttonValue);
						getSimpleDialog().close();
					}
				});
				buttonsPanel.add(aButton);
			}

			bottomPanel.add(Box.createRigidArea(new Dimension(0, 10)));
			bottomPanel.add(buttonsPanel);
		}

		// layouting
		this.setLayout(new BorderLayout(5, 5));
		this.add(new Label(messageString, Label.CENTER), BorderLayout.PAGE_START);
		this.add(selectionList, BorderLayout.CENTER);
		this.add(bottomPanel, BorderLayout.PAGE_END);

		defaultButton = acceptButton;
	}

	/**
	 * Initialize and build the components for requesting.
	 *
	 * @param messageString java.lang.String
	 * @param answerStringValue jp.co.sra.smalltalk.StValueHolder
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#_initializeToRequest(java.lang.String, jp.co.sra.smalltalk.StValueHolder)
	 * @category initialize-release
	 */
	public void _initializeToRequest(final String messageString, final StValueHolder answerStringValue) {
		this.removeAll();

		Canvas messageCanvas = new Canvas() {
			StComposedText composedText = new StComposedText(messageString);

			public Dimension getPreferredSize() {
				return composedText.extent();
			}

			public void paint(Graphics g) {
				super.paint(g);
				g.setColor(Color.black);
				int x = (this.getWidth() - composedText.width()) / 2;
				int y = (this.getHeight() - composedText.height()) / 2;
				composedText.displayOn_at_(g, new Point(x, y));
			}
		};

		final TextField textField = new TextField((String) answerStringValue.value()) {
			public Dimension getPreferredSize() {
				return new Dimension(200, this.getFont().getSize());
			}
		};
		textField.addTextListener(new TextListener() {
			public void textValueChanged(TextEvent e) {
				String newText = textField.getText();
				if (newText.equals(answerStringValue.value()) == false) {
					answerStringValue.value_(newText);
				}
			}
		});

		Panel buttonPanel = new Panel();
		buttonPanel.setLayout(new FlowLayout());
		Button acceptButton = new Button(this.getSimpleDialog()._acceptButtonLabelString());
		acceptButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().accept().value_(true);
			}
		});
		buttonPanel.add(acceptButton);
		Button cancelButton = new Button(this.getSimpleDialog()._cancelButtonLabelString());
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getSimpleDialog().cancel().value_(true);
			}
		});
		buttonPanel.add(cancelButton);
		defaultButton = acceptButton;

		this.setLayout(new GridLayout(3, 1));
		this.add(messageCanvas);
		this.add(textField);
		this.add(buttonPanel);
	}

	/**
	 * Answer my model as StSimpleDialog.
	 *
	 * @return jp.co.sra.smalltalk.StSimpleDialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#getSimpleDialog()
	 * @category model accessing
	 */
	public StSimpleDialog getSimpleDialog() {
		return (StSimpleDialog) this.model();
	}

	/**
	 * Create a default dialog.
	 *
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog()
	 * @category defaults
	 */
	public Dialog defaultDialog() {
		return this.defaultDialog(null);
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog(java.awt.Component)
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull) {
		return this.defaultDialog(aComponentOrNull, false);
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @param undecorated boolean
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog(java.awt.Component, boolean)
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull, boolean undecorated) {
		Window parentWindow = this.defaultParentWindow(aComponentOrNull);
		Dialog aDialog = null;
		if (parentWindow instanceof Frame) {
			aDialog = new Dialog((Frame) parentWindow, this.getSimpleDialog().windowTitle(), true);
		} else if (parentWindow instanceof Dialog) {
			aDialog = new Dialog((Dialog) parentWindow, this.getSimpleDialog().windowTitle(), true);
		} else {
			aDialog = new Dialog(SystemResourceSupport.getFrame(), this.getSimpleDialog().windowTitle(), true);
		}
		aDialog.setUndecorated(undecorated);
		aDialog.add(this);

		// A workaround for a problem with Java2 SDK 1.3.1 & 1.4.1 on Linux.
		// If a dialog contains a TextField, the dialog is tried to doLayout() with its size (0, 0)
		// when the peer of the TextField is created and addNotify() of the TextField is called.
		// As a result, the content of the dialog will be resized to be fit on a dialog which size is (0, 0).
		Insets insets = aDialog.getInsets();
		Dimension size = this.getSize();
		aDialog.setSize(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);

		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer the default parent window.
	 * 
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Window
	 * @category defaults
	 */
	protected Window defaultParentWindow(Component aComponentOrNull) {
		return StSimpleDialog.DefaultParentWindow(aComponentOrNull);
	}

	/**
	 * The view is realized, so gives the focus to the default button.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();

		// Gives the initial focus to the default button.
		this.topComponent().addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				super.windowOpened(e);

				if (defaultButton != null) {
					defaultButton.requestFocus();
				}
			}
		});
	}

}
