package jp.co.sra.smalltalk;

import java.awt.Component;
import java.awt.Dialog;

/**
 * StSimpleDialogView interface
 * 
 *  @author    nisinaka
 *  @created   2003/03/09 (by nisinaka)
 *  @updated   2007/10/04 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSimpleDialogView.java,v 8.12 2008/02/20 06:33:18 nisinaka Exp $
 */
public interface StSimpleDialogView extends StView {

	/**
	 * Initialize and build the components for choosing from the list.
	 * 
	 * @param messageString
	 * @param list
	 * @param listValues
	 * @param buttons
	 * @param buttonValues
	 * @param maxLines
	 * @param result
	 * @category initialize-release
	 */
	public void _initializeToChooseFromList(String messageString, String[] list, Object[] listValues, String[] buttons, Object[] buttonValues, int maxLines, StValueHolder result);

	/**
	 * Initialize and build the components for choosing.
	 *
	 * @param messageString java.lang.String
	 * @param labels java.lang.String[]
	 * @param values java.lang.Object[]
	 * @param defaultValue java.lang.Object
	 * @param result jp.co.sra.smalltalk.StValueHolder
	 * @param eqBoolean boolean
	 * @category initialize-release
	 */
	public void _initializeToChoose(String messageString, String[] labels, Object[] values, Object defaultValue, StValueHolder result, boolean eqBoolean);

	/**
	 * Initialize and build the components for requesting.
	 *
	 * @param messageString java.lang.String
	 * @param answerStringValue jp.co.sra.smalltalk.StValueHolder
	 * @category initialize-release
	 */
	public void _initializeToRequest(String messageString, StValueHolder answerStringValue);

	/**
	 * Answer my model as StSimpleDialog.
	 *
	 * @return jp.co.sra.smalltalk.StSimpleDialog
	 * @category model accessing
	 */
	public StSimpleDialog getSimpleDialog();

	/**
	 * Create a default dialog.
	 *
	 * @return java.awt.Dialog
	 * @category defaults
	 */
	public Dialog defaultDialog();

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Dialog
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull);

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @param undecorated boolean
	 * @return java.awt.Dialog
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull, boolean undecorated);

}
