package jp.co.sra.smalltalk;

/**
 * StSimpleDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/03/17 (by nisinaka)
 *  @updated   2006/04/19 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSimpleDialogTestExamples.java,v 8.11 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSimpleDialogTestExamples extends SmalltalkTestExamples {

	/**
	 * Example: show a dialog to choose.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_choose() {
		Object result;
		result = (new StSimpleDialog()).choose_labels_values_default_equalize_("Are you tired yet?", new String[] { "absolutely", "sort of", "not really" }, new StSymbol[] { $("yes"), $("maybe"), $("no") }, $("maybe"), true);
		System.out.println(result);
		result = (new StSimpleDialog()).choose_labels_values_default_equalize_("Are you completely sure?", new String[] { "definitely", "sort of no", "sort of yes", "nope" }, new StSymbol[] { $("yes"), $("maybeNo"), $("maybeYes"), $("no") }, $("no"),
				false);
		System.out.println(result);
		return true;
	}

	/**
	 * Example: show a dialog to choose from a list.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_chooseFromList() {
		Object result = new StSimpleDialog().choose_fromList_values_buttons_values_lines_cancel_("Which ones do you want?", new String[] { "first", "second", "third", "fourth" }, new Integer[] {
				new Integer(1),
				new Integer(2),
				new Integer(3),
				new Integer(4) }, new String[] { "Frobitz" }, new Object[] { null }, 8, new StBlockClosure() {
			public Object value() {
				return $("noChoice");
			}
		});
		System.out.println(result);

		return true;
	}

	/**
	 * Example: show a dialog to request.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_request() {
		Object result;
		result = (new StSimpleDialog()).request_initialAnswer_onCancel_("Your name?", "name", new StBlockClosure() {
			public Object value() {
				return "Freddy";
			}
		});
		System.out.println(result);
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StSimpleDialogTestExamples();
	}

}
