package jp.co.sra.smalltalk;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

/**
 * StController class
 * 
 *  @author    nisinaka
 *  @created   1998/12/09 (by nisinaka)
 *  @updated   1998/12/10 (by He Weijie)
 *  @updated   2002/11/11 (by nisinaka)
 *  @updated   2003/12/08 (by nisinaka)
 *  @updated   2004/04/26 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StController.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StController extends StObject implements KeyListener, MouseListener, MouseMotionListener {

	protected StView view;

	/**
	 * Create a new instance of StController and initialize it.
	 *
	 * @category Instance creation
	 */
	public StController() {
		super();
		this.initialize();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @category initialize-release
	 */
	public void initialize() {
		// Subclasses should include 'super initialize' when redefining this message to insure proper initialization.
	}

	/**
	 * Remove references to objects that may refer to the receiver.
	 * Remove the listeners of the view here as well.
	 * 
	 * @see jp.co.sra.smalltalk.StObject#release()
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	public void release() {
		super.release();

		this.view().toComponent().removeMouseListener(this);
		this.view().toComponent().removeMouseMotionListener(this);
	}

	/**
	 * Add myself as a listener of the view.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StController#release()
	 * @category initialize-release
	 */
	protected void buildListener(StView aView) {
		this.view().toComponent().addMouseListener(this);
		this.view().toComponent().addMouseMotionListener(this);
	}

	/**
	 * Answer the receiver's model which is the same as the model of the receiver's view.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	public StModel model() {
		return this.view().model();
	}

	/**
	 * Answer the receiver's view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category view accessing
	 */
	public StView view() {
		return view;
	}

	/**
	 * Set the receiver's view.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @category view accessing
	 */
	public void view_(StView aView) {
		view = aView;
		this.buildListener(aView);
	}

	/**
	 * Answer a Point indicating the cursor location on the view.
	 * 
	 * @return java.awt.Point
	 * @category cursor accessing
	 */
	public Point cursorPoint() {
		Point point = SystemInterface._MousePoint();
		Point viewLocation = this.view().toComponent().getLocationOnScreen();
		point.x = point.x - viewLocation.x;
		point.y = point.y - viewLocation.y;
		return point;
	}

	/**
	 * Set aPoint to be the current cursor location.
	 * 
	 * @param aPoint java.awt.Point
	 * @category cursor accessing
	 */
	public void cursorPoint_(Point aPoint) {
		Point point = this.view().toComponent().getLocationOnScreen();
		point.translate(aPoint.x, aPoint.y);
		SystemInterface._SetMousePoint(point.x, point.y);
	}

	/**
	 * Invoked when a key is pressed on the view.
	 * 
	 * @param e java.awt.event.KeyEvent
	 * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
	 * @category key events
	 */
	public void keyPressed(KeyEvent e) {
	}

	/**
	 * Invoked when a key is released on the view.
	 * 
	 * @param e java.awt.event.KeyEvent
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 * @category key events
	 */
	public void keyReleased(KeyEvent e) {
	}

	/**
	 * Invoked when a key is typed on the view.
	 * 
	 * @param e java.awt.event.KeyEvent
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 * @category key events
	 */
	public void keyTyped(KeyEvent e) {
	}

	/**
	 * Invoked when the mouse has been clicked on the view.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseClicked(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.view()._showPopupMenu(e.getX(), e.getY());
		}
	}

	/**
	 * Invoked when the mouse enters the view.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseEntered(MouseEvent e) {
	}

	/**
	 * Invoked when the mouse exits the view.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseExited(MouseEvent e) {
	}

	/**
	 * Invoked when a mouse button has been pressed on the view.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.view()._showPopupMenu(e.getX(), e.getY());
		}
	}

	/**
	 * Invoked when a mouse button has been released on the view.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.view()._showPopupMenu(e.getX(), e.getY());
		}
	}

	/**
	 * Invoked when a mouse is dragged on the view.
	 *
	 * @param e java.awt.event.MouseEvent 
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 * @category mouse motion events
	 */
	public void mouseDragged(MouseEvent e) {
	}

	/**
	 * Invoked when a mouse is moved on the view.
	 *
	 * @param e java.awt.event.MouseEvent 
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 * @category mouse motion events
	 */
	public void mouseMoved(MouseEvent e) {
	}

}