package jp.co.sra.smalltalk;

/**
 * StByteArrayTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/16 (by nisinaka)
 *  @updated   2002/04/17 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StByteArrayTestExamples.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StByteArrayTestExamples extends SmalltalkTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		StByteArray aByteArray = StByteArray.FromPackedString_("^24FS @a");

		return ((int) aByteArray.at_(1) == 123) && ((int) aByteArray.at_(2) == 45) && ((int) aByteArray.at_(3) == 6) && ((int) aByteArray.at_(4) == 78);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		byte[] bytes = new byte[] { 123, 45, 6, 78 };
		StByteArray aByteArray = new StByteArray(bytes);
		String packedString = aByteArray.asPackedString();

		System.out.println(packedString);

		return packedString.equals("^24FS @a");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		int[] bytes = new int[] { 123, 45, 6, 78 };
		StByteArray aByteArray = new StByteArray(bytes);
		String packedString = aByteArray.asPackedString();

		System.out.println(packedString);

		return packedString.equals("^24FS @a");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		StByteArray aByteArray = StByteArray.FromPackedString_("2MCT");
		int[] intArray = aByteArray._asInts();

		return (intArray[0] == 200) && (intArray[1] == 208) && (intArray[2] == 212);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		int[] bytes = new int[] { 200, 208, 212 };
		StByteArray aByteArray = new StByteArray(bytes);
		String packedString = aByteArray.asPackedString();

		System.out.println(packedString);

		return packedString.equals("2MCT");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		int[] bytes = new int[] { 200, 208, 212 };
		StByteArray aByteArray = new StByteArray(bytes);
		String storeString = aByteArray.storeString();

		System.out.println(storeString);

		return storeString.equals("#[200 208 212]");
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new StByteArrayTestExamples();
	}
}
