package jp.co.sra.smalltalk;

/**
 * StBlockValued interface
 * 
 *  @author    nisinaka
 *  @created   2003/03/07 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StBlockValued.java,v 8.9 2008/02/20 06:33:18 nisinaka Exp $
 */
public interface StBlockValued extends StValued {

	/**
	 * Add the dependent listener as my dependent.
	 *
	 * @param aDependentListener jp.co.sra.smalltalk.DependentListener
	 * @category dependents access
	 */
	public void addDependent_(DependentListener aDependentListener);

	/**
	 * Add the dependent listener as my dependnet.
	 * 
	 * @param aDependentListener jp.co.sra.smalltalk.DependentListener
	 * @category dependents access
	 */
	public void addDependentListener(DependentListener aDependentListener);

	/**
	 * Remove the dependent listener from the receiver's dependents.
	 * 
	 * @param aDependentListener jp.co.sra.smalltalk.DependentListener
	 * @category dependents access
	 */
	public void removeDependentListener(DependentListener aDependentListener);

}
