package jp.co.sra.smalltalk;

/**
 * DependentEvent class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/24 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: DependentEvent.java,v 8.9 2008/02/20 06:33:17 nisinaka Exp $
 */
public class DependentEvent extends java.util.EventObject {

	protected StSymbol aspect;
	protected Object parameter;

	/**
	 * Create a new instance of DependentEvent.
	 * 
	 * @param source java.lang.Object
	 * @param anAspect jp.co.sra.smalltalk.StSymbol
	 * @param aParameter java.lang.Object
	 * @category Instance creation
	 */
	public DependentEvent(Object source, StSymbol anAspect, Object aParameter) {
		super(source);
		aspect = anAspect;
		parameter = aParameter;
	}

	/**
	 * Answer my current aspect.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category accessing
	 */
	public StSymbol getAspect() {
		return aspect;
	}

	/**
	 * Answer my current parameter.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object getParameter() {
		return parameter;
	}

	/**
	 * Answer my string representation.
	 * 
	 * @return java.lang.String
	 * @see java.lang.Object#toString()
	 * @category printing
	 */
	public String toString() {
		return this.getClass().getName() + "[source=" + source + ",aspect=" + aspect + ",parameter=" + parameter + "]";
	}

}
