package jp.co.sra.qt4jun;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import quicktime.QTException;
import quicktime.app.view.QTComponent;
import quicktime.app.view.QTFactory;
import quicktime.std.movies.Movie;

/**
 * JunQTJPort class
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/30 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTJPort.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunQTJPort implements JunQTPort {
	private Container mv;

	private Movie movie;
	private QTComponent comp;

	/**
	 * constructor.
	 *
	 * @param mv java.awt.Component
	 * @category Instance creation
	 */
	public JunQTJPort(Component mv) {
		this.mv = (Container) mv;
		this.mv.setLayout(null);
	}

	/**
	 * finalize.
	 *
	 * @category initialize-release
	 */
	protected void finalize() {
		this.destroyPortAssociation();
	}

	/**
	 * create port association 1.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation1() {
		createComponent();
	}

	/**
	 * create port association 2.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation2() {
	}

	/**
	 * create the movie component.
	 *
	 * @category initialize-release
	 */
	public void createComponent() {
		try {
			if (movie == null) {
				movie = new Movie();
			}
			comp = QTFactory.makeQTComponent(movie);
			mv.add(comp.asComponent());
		} catch (QTException e) {
			throw new Error(e.getMessage());
		}
	}

	/**
	 * destroy port association.
	 *
	 * @category initialize-release
	 */
	public void destroyPortAssociation() {
		if (comp != null) {
			mv.remove(comp.asComponent());
			comp = null;
		}
		movie = null;
	}

	/**
	 * get the movie component.
	 *
	 * @return java.awt.Component
	 * @category accessing
	 */
	public Component getComponent() {
		return comp.asComponent();
	}

	/**
	 * set the movie box.
	 *
	 * @param movie jp.co.sra.qt4jun.JunQTMovie
	 * @param box java.awt.Rectangle
	 * @param offset java.awt.Point
	 * @category accessing
	 */
	public void setMovieBox(JunQTMovie movie, Rectangle box, Point offset) {
		comp.asComponent().setBounds(box);
	}

	/**
	 * set the movie.
	 *
	 * @param movie quicktime.std.movies.Movie
	 * @category private
	 */
	public void setMovie(Movie movie) {
		try {
			if (comp != null && movie != this.movie) {
				comp.setMovie(movie);
			}
			this.movie = movie;
		} catch (QTException e) {
			throw new Error(e.getMessage());
		}
	}
}
