package jp.co.sra.jun.vrml.support;

import java.util.Hashtable;
import jp.co.sra.jun.vrml.node.geometry.JunVrmlSphereNode;
import jp.co.sra.jun.vrml.node.geometry10.*;
import jp.co.sra.jun.vrml.node.grouping10.JunVrmlSeparatorNode;
import jp.co.sra.jun.vrml.node.property.JunVrmlNormalNode;
import jp.co.sra.jun.vrml.node.property10.*;

/**
 * JunVrmlSyntaxTreeBuilder10 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSyntaxTreeBuilder10.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlSyntaxTreeBuilder10 extends JunVrmlSyntaxTreeBuilder {
	/** The node type table of VRML1.0. */
	protected static Hashtable NodeTypeTable = null;

	//
	static {
		_InitializeNodeTypeTable();
	}

	/**
	 * Initialize the NodeTypeTable of VRML1.0.
	 */
	protected static void _InitializeNodeTypeTable() {
		NodeTypeTable = new Hashtable();
		NodeTypeTable.put($("Coordinate3"), JunVrmlCoordinate3Node.class);
		NodeTypeTable.put($("Cube"), JunVrmlCubeNode.class);
		NodeTypeTable.put($("IndexedFaceSet"), JunVrmlIndexedFaceSetNode10.class);
		NodeTypeTable.put($("IndexedLineSet"), JunVrmlIndexedLineSetNode10.class);
		NodeTypeTable.put($("Material"), JunVrmlMaterialNode10.class);
		NodeTypeTable.put($("Normal"), JunVrmlNormalNode.class);
		NodeTypeTable.put($("Separator"), JunVrmlSeparatorNode.class);
		NodeTypeTable.put($("Sphere"), JunVrmlSphereNode.class);
		NodeTypeTable.put($("Texture2"), JunVrmlTexture2Node.class);
		NodeTypeTable.put($("TextureCoordinate2"), JunVrmlTextureCoordinate2Node.class);
	}

	/**
	 * Answer a node type table.
	 * 
	 * @return java.util.Hashtable
	 */
	public Hashtable nodeTypeTable() {
		return NodeTypeTable;
	}
}
