package jp.co.sra.jun.vrml.support;

import jp.co.sra.smalltalk.StSymbol;
import java.util.*;

/**
 * JunVrmlParser10 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlParser10.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlParser10 extends JunVrmlParser {

	/**
	 * Parse a declaration and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseDeclaration() {
		this.nextToken();

		if ((tokenType == $("identifier")) || (tokenType == $("DEF")) || (tokenType == $("USE"))) {
			this.unNextToken();

			return this.parseNodeDeclaration();
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse declarations and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseDeclarations() {
		Vector tmpNode = new Vector();
		this.nextToken();

		while ((tokenType == $("identifier")) || (tokenType == $("DEF")) || (tokenType == $("USE"))) {
			this.unNextToken();

			if (this.parseDeclaration() == false) {
				failBlock.value_("Syntax error");

				return false;
			}

			tmpNode.addElement(parseNode);
			this.nextToken();
		}

		this.unNextToken();
		parseNode = tmpNode;

		return true;
	}

	/**
	 * Parse a field value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseFieldValue() {
		Vector values = new Vector();
		this.nextToken();

		if ((tokenType == $("TRUE")) || (tokenType == $("FALSE"))) {
			this.unNextToken();

			return this.parseSFBoolValue();
		}

		if (tokenType == $("number")) {
			this.nextToken();

			if (tokenType == $("number")) {
				this.unNextToken();
				this.unNextToken();

				return this.parseSFFloatValues();
			} else {
				this.unNextToken();
				values.addElement(token);
				parseNode = token;

				return true;
			}
		}

		if (tokenType == $("string")) {
			values.addElement(token);
			parseNode = token;

			return true;
		}

		if (tokenType == $("identifier")) {
			values.addElement(token);
			parseNode = token;

			return true;
		}

		if (tokenType == $("leftBracket")) {
			this.nextToken();

			if (tokenType == $("number")) {
				this.unNextToken();
				this.unNextToken();

				return this.parseMFFloatValue();
			}

			if (tokenType == $("string")) {
				this.unNextToken();
				this.unNextToken();

				return this.parseMFStringValue();
			}

			if (tokenType == $("rightBracket")) {
				return true;
			}
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse a MFFloat value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseMFFloatValue() {
		this.nextToken();

		if (tokenType == $("leftBracket")) {
			this.parseSFFloatValues();
			this.nextToken();

			if (tokenType == $("rightBracket")) {
				return true;
			}
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse a MFString value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseMFStringValue() {
		this.nextToken();

		if (tokenType == $("leftBracket")) {
			this.parseSFStringValues();
			this.nextToken();

			if (tokenType == $("rightBracket")) {
				return true;
			}
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse a node and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseNode() {
		this.nextToken();

		if (tokenType == $("identifier")) {
			StSymbol nodeName = (StSymbol) token;
			this.nextToken();

			if (tokenType == $("leftBrace")) {
				this.parseNodeGuts();
				parseNode = builder.newNode_with_(nodeName, parseNode);
				this.nextToken();

				if (tokenType == $("rightBrace")) {
					return true;
				}
			}
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse a node declaration and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseNodeDeclaration() {
		this.nextToken();

		if (tokenType == $("identifier")) {
			this.unNextToken();

			return this.parseNode();
		}

		if (tokenType == $("DEF")) {
			this.nextToken();

			if (tokenType == $("identifier")) {
				return this.parseNode();
			} else {
				return false;
			}
		}

		if (tokenType == $("USE")) {
			this.nextToken();

			if (tokenType == $("identifier")) {
				return true;
			} else {
				return false;
			}
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse a node gut and answer true if successfully parsed.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * 
	 * @return boolean
	 */
	public boolean parseNodeGut_(Hashtable aDictionary) {
		this.nextToken();

		if (tokenType == $("identifier")) {
			StSymbol fieldName = (StSymbol) token;
			this.nextToken();

			if ((tokenType == $("number")) || (tokenType == $("leftBracket")) || (tokenType == $("string")) || (tokenType == $("TRUE")) || (tokenType == $("FALSE"))) {
				this.unNextToken();

				if (this.parseFieldValue() == false) {
					failBlock.value_("Syntax error");

					return false;
				}

				aDictionary.put(fieldName, parseNode);

				return true;
			}

			if (tokenType == $("leftBrace")) {
				this.unNextToken();
				this.unNextToken();

				return this.parseNodeDeclaration();
			} else {
				return false;
			}
		}

		if ((tokenType == $("DEF")) || (tokenType == $("USE"))) {
			this.unNextToken();

			return this.parseNodeDeclaration();
		}

		failBlock.value_("Syntax error");

		return false;
	}

	/**
	 * Parse node guts and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseNodeGuts() {
		Hashtable parseFields = new Hashtable();
		Vector parseNodes = new Vector();
		this.nextToken();

		while ((tokenType == $("identifier")) || (tokenType == $("DEF")) || (tokenType == $("USE"))) {
			this.unNextToken();

			if (this.parseNodeGut_(parseFields) == false) {
				failBlock.value_("Syntax error");

				return false;
			}

			if (parseFields.isEmpty()) {
				parseNodes.addElement(parseNode);
			}

			this.nextToken();
		}

		this.unNextToken();

		if (parseFields.isEmpty()) {
			parseNode = parseNodes;
		} else {
			parseNode = parseFields;
		}

		return true;
	}

	/**
	 * Parse a SFBool value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseSFBoolValue() {
		Vector boolValues = new Vector();
		this.nextToken();

		while ((tokenType == $("TRUE")) || (tokenType == $("FALSE"))) {
			boolValues.addElement(token);
		}

		parseNode = boolValues;

		return true;
	}

	/**
	 * Parse a SFFloat value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseSFFloatValues() {
		Vector floatValues = new Vector();
		this.nextToken();

		while ((tokenType == $("number")) || (tokenType == $("comma"))) {
			if (tokenType == $("number")) {
				floatValues.addElement(token);
			}

			this.nextToken();
		}

		this.unNextToken();
		parseNode = floatValues;

		return true;
	}

	/**
	 * Parse a SFString value and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseSFStringValues() {
		Vector stringValues = new Vector();
		this.nextToken();

		while ((tokenType == $("string")) || (tokenType == $("comma"))) {
			stringValues.addElement(token);
			this.nextToken();
		}

		this.unNextToken();
		parseNode = stringValues;

		return true;
	}

	/**
	 * Parse a VRML scene and answer true if successfully parsed.
	 * 
	 * @return boolean
	 */
	public boolean parseVrmlScene() {
		return this.parseDeclarations();
	}

	/**
	 * Answer an instance of the default syntax tree builder.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlSyntaxTreeBuilder
	 */
	protected JunVrmlSyntaxTreeBuilder defaultBuilder() {
		return new JunVrmlSyntaxTreeBuilder10();
	}

	/**
	 * Answer the default keyword table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlKeywordTable
	 */
	protected JunVrmlKeywordTable defaultKeywordTable() {
		return JunVrmlKeywordTable10.KeywordTable();
	}

	/**
	 * Answer the default scanner table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlScannerTable
	 */
	protected JunVrmlScannerTable defaultScannerTable() {
		return JunVrmlScannerTable10.ScannerTable();
	}
}
