package jp.co.sra.jun.vrml.support;

/**
 * JunVrmlKeywordTable97 class
 * 
 *  @author    nisinaka
 *  @created   2000/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlKeywordTable97.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlKeywordTable97 extends JunVrmlKeywordTable {
	/** The keyword table for VRML97. */
	protected static JunVrmlKeywordTable keywordTable = null;

	static {
		Initialize();
	}

	/**
	 * Constructor.
	 */
	public JunVrmlKeywordTable97() {
		super();
	}

	/**
	 * Constructor.
	 * 
	 * @param nSize int
	 */
	public JunVrmlKeywordTable97(int nSize) {
		super(nSize);
	}

	/**
	 * Answer the keyword table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlKeywordTable
	 */
	public static JunVrmlKeywordTable KeywordTable() {
		return keywordTable;
	}

	/**
	 * Initialize the keyword table.
	 */
	protected static void Initialize() {
		JunVrmlKeywordTable97 newTable = new JunVrmlKeywordTable97(33);
		newTable.put(0, $("NULL"));
		newTable.put(1, $("DEF"));
		newTable.put(2, $("USE"));
		newTable.put(3, $("PROTO"));
		newTable.put(4, $("eventIn"));
		newTable.put(5, $("eventOut"));
		newTable.put(6, $("field"));
		newTable.put(7, $("exposedField"));
		newTable.put(8, $("EXTERNPROTO"));
		newTable.put(9, $("ROUTE"));
		newTable.put(10, $("TO"));
		newTable.put(11, $("Script"));
		newTable.put(12, $("IS"));
		newTable.put(13, $("MFColor"));
		newTable.put(14, $("MFFloat"));
		newTable.put(15, $("MFInt32"));
		newTable.put(16, $("MFNode"));
		newTable.put(17, $("MFRotation"));
		newTable.put(18, $("MFString"));
		newTable.put(19, $("MFVec2f"));
		newTable.put(20, $("MFVec3f"));
		newTable.put(21, $("SFBool"));
		newTable.put(22, $("SFColor"));
		newTable.put(23, $("SFFloat"));
		newTable.put(24, $("SFImage"));
		newTable.put(25, $("SFNode"));
		newTable.put(26, $("SFRotation"));
		newTable.put(27, $("SFString"));
		newTable.put(28, $("SFTime"));
		newTable.put(29, $("SFVec2f"));
		newTable.put(30, $("SFVec3f"));
		newTable.put(31, $("TRUE"));
		newTable.put(32, $("FALSE"));
		keywordTable = newTable;
	}
}
