package jp.co.sra.jun.vrml.support;

/**
 * JunVrmlKeywordTable10 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   1999/06/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlKeywordTable10.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlKeywordTable10 extends JunVrmlKeywordTable {
	/** The keyword table for VRML1.0. */
	protected static JunVrmlKeywordTable keywordTable = null;

	static {
		Initialize();
	}

	/**
	 * Create a new instance of JunVrmlKeywordTable10.
	 */
	public JunVrmlKeywordTable10() {
		super();
	}

	/**
	 * Create a new instance of JunVrmlKeywordTable10.
	 * 
	 * @param nSize int
	 */
	public JunVrmlKeywordTable10(int nSize) {
		super(nSize);
	}

	/**
	 * Answer the keyword table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlKeywordTable
	 */
	public static JunVrmlKeywordTable KeywordTable() {
		return keywordTable;
	}

	/**
	 * Initialize the keyword table.
	 */
	protected static void Initialize() {
		JunVrmlKeywordTable10 newTable = new JunVrmlKeywordTable10(4);
		newTable.put(0, $("DEF"));
		newTable.put(1, $("USE"));
		newTable.put(2, $("TRUE"));
		newTable.put(3, $("FALSE"));
		keywordTable = newTable;
	}
}
