package jp.co.sra.jun.vrml.support;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;
import jp.co.sra.jun.vrml.node.geometry20.JunVrmlIndexedFaceSetNode20;
import jp.co.sra.jun.vrml.node.geometry20.JunVrmlIndexedLineSetNode20;
import jp.co.sra.jun.vrml.node.grouping20.JunVrmlGroupNode;
import jp.co.sra.jun.vrml.node.grouping20.JunVrmlShapeNode;
import jp.co.sra.jun.vrml.node.grouping20.JunVrmlTransformNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlAppearanceNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlBackgroundNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlDirectionalLightNode20;
import jp.co.sra.jun.vrml.node.property20.JunVrmlNavigationInfoNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlPointLightNode20;
import jp.co.sra.jun.vrml.node.property20.JunVrmlTextureCoordinateNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlViewpointNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlWorldInfoNode;

/**
 * JunVrmlGenerator97 class
 * 
 *  @author    nisinaka
 *  @created   2000/03/27 (by nisinaka)
 *  @updated   2004/11/02 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun627 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlGenerator97.java,v 8.11 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlGenerator97 extends JunVrmlGenerator {

	/**
	 * Process the Appearance node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlAppearanceNode
	 * @category enumerating
	 */
	public void doAppearance_(JunVrmlAppearanceNode aNode) {
		if (aNode.material() != null) {
			this.addPropertyNode_(aNode.material());
		}
		if (aNode.texture() != null) {
			this.informationAt_put_($("texture"), aNode.texture());
		}
	}

	/**
	 * Process the Background node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlBackgroundNode
	 * @category enumerating
	 */
	public void doBackground_(JunVrmlBackgroundNode aNode) {
		this.informationAt_put_($("background"), aNode);
	}

	/**
	 * Process the DirectionalLight node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlDirectionalLightNode20
	 * @category enumerating
	 */
	public void doDirectionalLight_(JunVrmlDirectionalLightNode20 aNode) {
		JunOpenGLDisplayLight aLight = aNode.asJunOpenGLDisplayLight();
		this.addLight_(aLight);
	}

	/**
	 * Process the PointLight node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlPointLightNode20
	 * @category enumerating
	 */
	public void doPointLight_(JunVrmlPointLightNode20 aNode) {
		JunOpenGLDisplayLight aLight = aNode.asJunOpenGLDisplayLight();
		this.addLight_(aLight);
	}

	/**
	 * Process the Group node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.grouping20.JunVrmlGroupNode
	 * @category enumerating
	 */
	public void doGroup_(JunVrmlGroupNode aNode) {
		JunVrmlGenerator newGenerator = new JunVrmlGenerator97();
		JunVrmlNode[] children = aNode.children();
		if (children == null) {
			return;
		}

		for (int i = 0; i < children.length; i++) {
			children[i].nodeDo_(newGenerator);
		}
		JunOpenGL3dObject newObject = newGenerator.object();
		if (newObject != null) {
			newGenerator.propertyOn_(newObject);
			this.addObject_(newObject);
			newGenerator.object_(null);
		}

		this.add_(newGenerator);
	}

	/**
	 * Process the IndexedFaceSet node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.geometry20.JunVrmlIndexedFaceSetNode20
	 * @category enumerating
	 */
	public void doIndexedFaceSet_(JunVrmlIndexedFaceSetNode20 aNode) {
		JunOpenGL3dObject a3dObject = aNode.asJunOpenGL3dObject();
		if (a3dObject == null) {
			return;
		}

		JunVrmlAbstractPropertyNode textureNode = (JunVrmlAbstractPropertyNode) this.informationAt_($("texture"));
		if (textureNode != null) {
			textureNode.propertyOn_(a3dObject);
			aNode.texCoordOn_(a3dObject);
		}

		this.addObject_(a3dObject);
	}

	/**
	 * Process the IndexedLineSet node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.geometry20.JunVrmlIndexedLineSetNode20
	 * @category enumerating
	 */
	public void doIndexedLineSet_(JunVrmlIndexedLineSetNode20 aNode) {
		JunOpenGL3dObject a3dObject = aNode.asJunOpenGL3dObject();
		if (a3dObject != null) {
			this.addObject_(a3dObject);
		}
	}

	/**
	 * Process the NavigationInfo node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlNavigationInfoNode
	 * @category enumerating
	 */
	public void doNavigationInfo_(JunVrmlNavigationInfoNode aNode) {
		this.informationAt_put_($("navigationInfo"), aNode);
	}

	/**
	 * Process the Shape node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.grouping20.JunVrmlShapeNode
	 * @category enumerating
	 */
	public void doShape_(JunVrmlShapeNode aNode) {
		if (aNode.geometry() == null) {
			return;
		}

		// The order of the processing is quite important.
		// Sometimes properties in the appearance node
		// are used to process the geometry node.
		JunVrmlGenerator newGenerator = new JunVrmlGenerator97();
		if (aNode.appearance() != null) {
			aNode.appearance().nodeDo_(newGenerator);
		}

		aNode.geometry().nodeDo_(newGenerator);

		JunOpenGL3dObject newObject = newGenerator.object();
		if (newObject != null) {
			newGenerator.propertyOn_(newObject);
			// this.object_(newObject);
			// newGenerator.object_(null);
		}

		this.add_(newGenerator);
	}

	/**
	 * Process the TextureCoordinate node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlTextureCoordinateNode
	 * @category enumerating
	 */
	public void doTextureCoordinate_(JunVrmlTextureCoordinateNode aNode) {
		this.informationAt_put_($("textureCoordinate"), aNode);
	}

	/**
	 * Process the Transform node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.grouping20.JunVrmlTransformNode
	 * @category enumerating
	 */
	public void doTransform_(JunVrmlTransformNode aNode) {
		JunVrmlGenerator newGenerator = new JunVrmlGenerator97();
		JunVrmlNode[] children = aNode.children();
		for (int i = 0; i < children.length; i++) {
			children[i].nodeDo_(newGenerator);
		}

		JunOpenGL3dObject newObject = newGenerator.object();
		if (newObject != null) {
			newObject = newObject.transform_(aNode.transformation());
			newGenerator.propertyOn_(newObject);
			this.addObject_(newObject);
			newGenerator.object_(null);
		}

		this.add_(newGenerator);
	}

	/**
	 * Process the Viewpoint node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlViewpointNode
	 * @category enumerating
	 */
	public void doViewpoint_(JunVrmlViewpointNode aNode) {
		ArrayList aList = (ArrayList) this.informationAt_($("viewpoint"));
		if (aList != null) {
			aList.add(aNode);
		} else {
			aList = new ArrayList();
			aList.add(aNode);
			this.informationAt_put_($("viewpoint"), aList);
		}
	}

	/**
	 * Process the WorldInfo node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlWorldInfoNode
	 * @category enumerating
	 */
	public void doWorldInfo_(JunVrmlWorldInfoNode aNode) {
		this.informationAt_put_($("worldInfo"), aNode);
	}

	/**
	 * Set the lights on the JunOpenGLDisplayModel.
	 * 
	 * @param aDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category private
	 */
	protected void setLights_(JunOpenGLDisplayModel aDisplayModel) {
		aDisplayModel.displayLightsAllOff();

		JunVrmlNavigationInfoNode navigationInfoNode = (JunVrmlNavigationInfoNode) this.informationAt_($("navigationInfo"));
		if ((navigationInfoNode == null) || (navigationInfoNode.headlight() == true)) {
			// Use the default light of the display model.
			aDisplayModel.displayLight1().beOn();
		}

		// Use the ambient light anyway.
		aDisplayModel.displayLight5().beOn();

		Vector lights = this.lights();
		if (lights == null) {
			return;
		}

		// displayLight2
		if (lights.size() > 0) {
			aDisplayModel.displayLights()[1] = (JunOpenGLDisplayLight) lights.elementAt(0);
			aDisplayModel.displayLights()[1].beOn();
		}

		// displayLight3
		if (lights.size() > 1) {
			aDisplayModel.displayLights()[2] = (JunOpenGLDisplayLight) lights.elementAt(1);
			aDisplayModel.displayLights()[2].beOn();
		}
		// displayLight4
		if (lights.size() > 2) {
			aDisplayModel.displayLights()[3] = (JunOpenGLDisplayLight) lights.elementAt(2);
			aDisplayModel.displayLights()[3].beOn();
		}
	}

	/**
	 * Set the projection to the JunOpenGLDisplayModel.
	 * 
	 * @param aDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category private
	 */
	protected void setProjection_(JunOpenGLDisplayModel aDisplayModel) {
		JunVrmlBackgroundNode backgroundNode = (JunVrmlBackgroundNode) this.informationAt_($("background"));
		if (backgroundNode != null) {
			Color[] colors = backgroundNode.skyColorAsColors();
			if (colors != null && colors.length > 0 && colors[0] != null) {
				aDisplayModel.backgroundColor_(colors[0]);
			}
		}

		JunVrmlNavigationInfoNode navigationInfoNode = (JunVrmlNavigationInfoNode) this.informationAt_($("navigationInfo"));
		if (navigationInfoNode == null) {
			navigationInfoNode = new JunVrmlNavigationInfoNode();
		}

		ArrayList viewpoints = (ArrayList) this.informationAt_($("viewpoint"));
		if (viewpoints == null) {
			viewpoints = new ArrayList();
		}
		if (viewpoints.isEmpty()) {
			viewpoints.add(new JunVrmlViewpointNode());
		}

		JunOpenGLPerspectiveProjection[] projections = new JunOpenGLPerspectiveProjection[viewpoints.size()];
		for (int i = 0; i < projections.length; i++) {
			JunVrmlViewpointNode viewpointNode = (JunVrmlViewpointNode) viewpoints.get(i);
			Jun3dPoint eyePoint = viewpointNode.positionAs3dPoint();
			Jun3dPoint upVector = (new Jun3dPoint(0, 1, 0)).transform_(viewpointNode.orientationAs3dTransformation()).unitVector();
			float[] avatarSize = navigationInfoNode.avatarSize();
			Jun3dPoint sightPoint = (avatarSize.length >= 6) ? new Jun3dPoint(avatarSize[3], avatarSize[4], avatarSize[5]) : aDisplayModel.boundingBox().center();
			double viewFactor = (navigationInfoNode.visibilityLimit() > 0) ? navigationInfoNode.visibilityLimit() / eyePoint.distance_(sightPoint) : aDisplayModel.defaultViewFactor();
			double zoomHeight = Math.tan(viewpointNode.fieldOfView() / 2) * eyePoint.distance_(sightPoint) * 2;

			projections[i] = new JunOpenGLPerspectiveProjection();
			projections[i].description_(viewpointNode.description());
			projections[i].eyePoint_(eyePoint);
			projections[i].sightPoint_(sightPoint);
			projections[i].upVector_(upVector);
			projections[i].viewFactor_(viewFactor);
			projections[i].zoomHeight_(zoomHeight);
		}

		aDisplayModel.presetProjections_(projections);
		aDisplayModel.defaultProjection_(projections[0]);
		aDisplayModel.flushProjector();
	}

}
