package jp.co.sra.jun.vrml.support;

import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;
import jp.co.sra.jun.vrml.node.geometry10.*;
import jp.co.sra.jun.vrml.node.grouping10.JunVrmlSeparatorNode;
import jp.co.sra.jun.vrml.node.property10.*;

/**
 * JunVrmlGenerator10 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlGenerator10.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlGenerator10 extends JunVrmlGenerator {

	/**
	 * Process the Coordinate3 node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property10.JunVrmlCoordinate3Node
	 */
	public void doCoordinate3_(JunVrmlCoordinate3Node aNode) {
		this.informationAt_put_($("coordinate3"), aNode);
	}

	/**
	 * Process the IndexedFaseSet node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.geometry10.JunVrmlIndexedFaceSetNode10
	 */
	public void doIndexedFaceSet_(JunVrmlIndexedFaceSetNode10 aNode) {
		JunVrmlCoordinate3Node aCoordinate3Node = (JunVrmlCoordinate3Node) this.informationAt_($("coordinate3"));

		if (aCoordinate3Node != null) {
			JunOpenGL3dObject a3dObject = aNode.asJunOpenGL3dObjectWithCoordinate3_(aCoordinate3Node);
			JunVrmlTexture2Node aTexture2Node = (JunVrmlTexture2Node) this.informationAt_($("texture2"));

			if (aTexture2Node != null) {
				aTexture2Node.propertyOn_(a3dObject);

				JunVrmlTextureCoordinate2Node aTextureCoordinate2Node = (JunVrmlTextureCoordinate2Node) this.informationAt_($("textureCoordinate2"));

				if (aTextureCoordinate2Node != null) {
					aNode.textureCoordinate_on_(aTextureCoordinate2Node, a3dObject);
				}
			}

			this.propertyOn_(a3dObject);
			this.addObject_(a3dObject);
		}
	}

	/**
	 * Process the IndexedLineSet node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.geometry10.JunVrmlIndexedLineSetNode10
	 */
	public void doIndexedLineSet_(JunVrmlIndexedLineSetNode10 aNode) {
		JunVrmlCoordinate3Node aCoordinate3Node = (JunVrmlCoordinate3Node) this.informationAt_($("coordinate3"));

		if (aCoordinate3Node != null) {
			JunOpenGL3dObject a3dObject = aNode.asJunOpenGL3dObjectWithCoordinate3_(aCoordinate3Node);
			this.propertyOn_(a3dObject);
			this.addObject_(a3dObject);
		}
	}

	/**
	 * Process the Separator node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.group10.JunVrmlSeparatorNode
	 */
	public void doSeparator_(JunVrmlSeparatorNode aNode) {
		JunVrmlGenerator10 newGenerator = new JunVrmlGenerator10();
		JunVrmlNode[] nodes = aNode.nodes();

		for (int i = 0; i < nodes.length; i++) {
			nodes[i].nodeDo_(newGenerator);
		}

		JunOpenGL3dObject newObject = newGenerator.object();

		if (newObject != null) {
			newGenerator.propertyOn_(newObject);
			this.addObject_(newObject);
		}
	}

	/**
	 * Process the Texture2 node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property10.JunVrmlTexture2Node
	 */
	public void doTexture2_(JunVrmlTexture2Node aNode) {
		this.informationAt_put_($("texture2"), aNode);
	}

	/**
	 * Process the TextureCoordinate2 node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property10.JunVrmlTextureCoordinate2Node
	 */
	public void doTextureCoordinate2_(JunVrmlTextureCoordinate2Node aNode) {
		this.informationAt_put_($("textureCoordinate2"), aNode);
	}
}
