package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlViewpointNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @updated   2003/07/01 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlViewpointNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlViewpointNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {

	protected JunVrmlSFFloatField fieldOfViewField;
	protected JunVrmlSFBoolField jumpField;
	protected JunVrmlSFRotationField orientationField;
	protected JunVrmlSFVec3fField positionField;
	protected JunVrmlSFStringField descriptionField;

	/**
	 * Create a new instance of JunVrmlViewpointNode and initialize it.
	 */
	public JunVrmlViewpointNode() {
	}

	/**
	 * Create a new instance of JunVrmlViewpointNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlViewpointNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("fieldOfView"))) {
			fieldOfViewField = new JunVrmlSFFloatField(aDictionary.get($("fieldOfView")));
		}

		if (aDictionary.containsKey($("jump"))) {
			jumpField = new JunVrmlSFBoolField(aDictionary.get($("jump")));
		}

		if (aDictionary.containsKey($("orientation"))) {
			orientationField = new JunVrmlSFRotationField(aDictionary.get($("orientation")));
		}

		if (aDictionary.containsKey($("position"))) {
			positionField = new JunVrmlSFVec3fField(aDictionary.get($("position")));
		}

		if (aDictionary.containsKey($("description"))) {
			descriptionField = new JunVrmlSFStringField(aDictionary.get($("description")));
		}
	}

	/**
	 * Answer the default value of description.
	 * 
	 * @return java.lang.String
	 */
	public static String DefaultDescription() {
		return "";
	}

	/**
	 * Answer the default value of fieldOfView.
	 * 
	 * @return float
	 */
	public static float DefaultFieldOfView() {
		return 0.785398f;
	}

	/**
	 * Answer the default value of jump.
	 * 
	 * @return boolean
	 */
	public static boolean DefaultJump() {
		return true;
	}

	/**
	 * Answer the default value of orientation.
	 * 
	 * @return float[]
	 */
	public static float[] DefaultOrientation() {
		return new float[] { 0, 0, 1, 0 };
	}

	/**
	 * Answer the default value of position.
	 * 
	 * @return float[]
	 */
	public static float[] DefaultPosition() {
		return new float[] { 0, 0, 10 };
	}

	/**
	 * Answer the description.
	 * 
	 * @return java.lang.String
	 */
	public String description() {
		return this.descriptionField().value();
	}

	/**
	 * Answer the fieldOfView.
	 * 
	 * @return float
	 */
	public float fieldOfView() {
		return this.fieldOfViewField().value();
	}

	/**
	 * Answer the jump.
	 * 
	 * @return boolean
	 */
	public boolean jump() {
		return this.jumpField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doViewpoint_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the orientation.
	 * 
	 * @return float[]
	 */
	public float[] orientation() {
		return this.orientationField().value();
	}

	/**
	 * Answer the orientation as a Jun3dTransformation.
	 *
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	public Jun3dTransformation orientationAs3dTransformation() {
		return this.orientationField().as3dTransformation();
	}

	/**
	 * Answer the position.
	 * 
	 * @return float[]
	 */
	public float[] position() {
		return this.positionField().value();
	}

	/**
	 * Answer the position as a Jun3dPoint.
	 *
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint positionAs3dPoint() {
		return this.positionField().as3dPoint();
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Answer the description field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField
	 */
	protected JunVrmlSFStringField descriptionField() {
		if (descriptionField == null) {
			descriptionField = new JunVrmlSFStringField(DefaultDescription());
		}

		return descriptionField;
	}

	/**
	 * Answer the fieldOfView.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField fieldOfViewField() {
		if (fieldOfViewField == null) {
			fieldOfViewField = new JunVrmlSFFloatField(DefaultFieldOfView());
		}

		return fieldOfViewField;
	}

	/**
	 * Answer the jump field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.convexField
	 */
	protected JunVrmlSFBoolField jumpField() {
		if (jumpField == null) {
			jumpField = new JunVrmlSFBoolField(DefaultJump());
		}

		return jumpField;
	}

	/**
	 * Answer the orientation field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFRotationField
	 */
	protected JunVrmlSFRotationField orientationField() {
		if (orientationField == null) {
			orientationField = new JunVrmlSFRotationField(DefaultOrientation());
		}

		return orientationField;
	}

	/**
	 * Answer the position field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 */
	protected JunVrmlSFVec3fField positionField() {
		if (positionField == null) {
			positionField = new JunVrmlSFVec3fField(DefaultPosition());
		}

		return positionField;
	}
}
