package jp.co.sra.jun.vrml.node.property20;

import java.awt.Image;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlPixelTextureNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlPixelTextureNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlPixelTextureNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlSFImageField imageField;
	protected JunVrmlSFBoolField repeatSField;
	protected JunVrmlSFBoolField repeatTField;

	/**
	 * The default constructor.
	 */
	public JunVrmlPixelTextureNode() {
	}

	/**
	 * Create a new instance of JunVrmlPixelTextureNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlPixelTextureNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("image"))) {
			imageField = new JunVrmlSFImageField(aDictionary.get($("image")));
		}

		if (aDictionary.containsKey($("repeatS"))) {
			repeatSField = new JunVrmlSFBoolField(aDictionary.get($("repeatS")));
		}

		if (aDictionary.containsKey($("repeatT"))) {
			repeatTField = new JunVrmlSFBoolField(aDictionary.get($("repeatT")));
		}
	}

	/**
	 * Answer the default value of image.
	 * 
	 * @return int[]
	 */
	public static int[] DefaultImage() {
		return new int[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of repeatS.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public static boolean DefaultRepeatS() {
		return true;
	}

	/**
	 * Answer the default value of repeatT.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public static boolean DefaultRepeatT() {
		return true;
	}

	/**
	 * Answer the image.
	 * 
	 * @return int[]
	 */
	public int[] image() {
		return this.imageField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doPixelTexture_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		Image anImage = this.imageField().asImage();

		if (anImage != null) {
			a3dObject.texture_(new JunOpenGLTexture(anImage));
		}
	}

	/**
	 * Answer the repeatS.
	 * 
	 * @return boolean
	 */
	public boolean repeatS() {
		return this.repeatSField().value();
	}

	/**
	 * Answer the repeatT.
	 * 
	 * @return boolean
	 */
	public boolean repeatT() {
		return this.repeatTField().value();
	}

	/**
	 * Answer the image field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFImageField
	 */
	protected JunVrmlSFImageField imageField() {
		if (imageField == null) {
			imageField = new JunVrmlSFImageField(DefaultImage());
		}

		return imageField;
	}

	/**
	 * Answer the repeatS field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField repeatSField() {
		if (repeatSField == null) {
			repeatSField = new JunVrmlSFBoolField(DefaultRepeatS());
		}

		return repeatSField;
	}

	/**
	 * Answer the repeatT field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField repeatTField() {
		if (repeatTField == null) {
			repeatTField = new JunVrmlSFBoolField(DefaultRepeatT());
		}

		return repeatTField;
	}
}
