package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.*;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlNavigationInfoNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlNavigationInfoNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlNavigationInfoNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlMFFloatField avatarSizeField;
	protected JunVrmlSFBoolField headlightField;
	protected JunVrmlSFFloatField speedField;
	protected JunVrmlMFStringField typeField;
	protected JunVrmlSFFloatField visibilityLimitField;

	/**
	 * Create a new instance of JunVrmlNavigationInfoNode and initialize it.
	 */
	public JunVrmlNavigationInfoNode() {
	}

	/**
	 * Create a new instance of JunVrmlNavigationInfoNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlNavigationInfoNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("avatarSize"))) {
			avatarSizeField = new JunVrmlMFFloatField(aDictionary.get($("avatarSize")));
		}

		if (aDictionary.containsKey($("headlight"))) {
			headlightField = new JunVrmlSFBoolField(aDictionary.get($("headlight")));
		}

		if (aDictionary.containsKey($("speed"))) {
			speedField = new JunVrmlSFFloatField(aDictionary.get($("speed")));
		}

		if (aDictionary.containsKey($("type"))) {
			typeField = new JunVrmlMFStringField(aDictionary.get($("type")));
		}

		if (aDictionary.containsKey($("visibilityLimit"))) {
			visibilityLimitField = new JunVrmlSFFloatField(aDictionary.get($("visibilityLimit")));
		}
	}

	/**
	 * Answer the default value of avatarSize.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultAvatarSize() {
		return new float[] { 0.25f, 1.6f, 0.75f };
	}

	/**
	 * Answer the default value of headlight.
	 * 
	 * @return boolean
	 */
	public static final boolean DefaultHeadlight() {
		return true;
	}

	/**
	 * Answer the default value of speed.
	 * 
	 * @return float
	 */
	public static final float DefaultSpeed() {
		return 1.0f;
	}

	/**
	 * Answer the default value of speed.
	 * 
	 * @return java.lang.String[]
	 */
	public static String[] DefaultType() {
		return new String[] { "WALK", "ANY" };
	}

	/**
	 * Answer the default value of visibilityLimit.
	 * 
	 * @return float
	 */
	public static final float DefaultVisibilityLimit() {
		return 0.0f;
	}

	/**
	 * Answer the avatarSize.
	 * 
	 * @return float[]
	 */
	public float[] avatarSize() {
		return this.avatarSizeField().value();
	}

	/**
	 * Answer the headlight.
	 * 
	 * @return boolean
	 */
	public boolean headlight() {
		return this.headlightField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doNavigationInfo_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Answer the speed.
	 * 
	 * @return float
	 */
	public float speed() {
		return this.speedField().value();
	}

	/**
	 * Answer the type.
	 * 
	 * @return java.lang.String[]
	 */
	public String[] type() {
		return this.typeField().value();
	}

	/**
	 * Answer the visibilityLimit.
	 * 
	 * @return float
	 */
	public float visibilityLimit() {
		return this.visibilityLimitField().value();
	}

	/**
	 * Answer the avatarSize field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFFloatField
	 */
	protected JunVrmlMFFloatField avatarSizeField() {
		if (avatarSizeField == null) {
			avatarSizeField = new JunVrmlMFFloatField(DefaultAvatarSize());
		}

		return avatarSizeField;
	}

	/**
	 * Answer the headlight field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField headlightField() {
		if (headlightField == null) {
			headlightField = new JunVrmlSFBoolField(DefaultHeadlight());
		}

		return headlightField;
	}

	/**
	 * Answer the speed field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField speedField() {
		if (speedField == null) {
			speedField = new JunVrmlSFFloatField(DefaultSpeed());
		}

		return speedField;
	}

	/**
	 * Answer the type field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField
	 */
	protected JunVrmlMFStringField typeField() {
		if (typeField == null) {
			typeField = new JunVrmlMFStringField(DefaultType());
		}

		return typeField;
	}

	/**
	 * Answer the visivilityLimit field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField visibilityLimitField() {
		if (visibilityLimitField == null) {
			visibilityLimitField = new JunVrmlSFFloatField(DefaultVisibilityLimit());
		}

		return visibilityLimitField;
	}
}
