package jp.co.sra.jun.vrml.node.property20;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlMaterialNode20 class
 * 
 *  @author    nisinaka
 *  @created   2000/04/14 (by nisinaka)
 *  @updated   2003/07/01 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMaterialNode20.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlMaterialNode20 extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {

	protected JunVrmlSFFloatField ambientIntensityField;
	protected JunVrmlSFColorField diffuseColorField;
	protected JunVrmlSFColorField emissiveColorField;
	protected JunVrmlSFFloatField shininessField;
	protected JunVrmlSFColorField specularColorField;
	protected JunVrmlSFFloatField transparencyField;

	/**
	 * The default constructor.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlMaterialNode20() {
	}

	/**
	 * Create a new instance of JunVrmlMaterialNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlMaterialNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("ambientIntensity"))) {
			ambientIntensityField = new JunVrmlSFFloatField(aDictionary.get($("ambientIntensity")));
		}

		if (aDictionary.containsKey($("diffuseColor"))) {
			diffuseColorField = new JunVrmlSFColorField(aDictionary.get($("diffuseColor")));
		}

		if (aDictionary.containsKey($("emissiveColor"))) {
			emissiveColorField = new JunVrmlSFColorField(aDictionary.get($("emissiveColor")));
		}

		if (aDictionary.containsKey($("shininess"))) {
			shininessField = new JunVrmlSFFloatField(aDictionary.get($("shininess")));
		}

		if (aDictionary.containsKey($("specularColor"))) {
			specularColorField = new JunVrmlSFColorField(aDictionary.get($("specularColor")));
		}

		if (aDictionary.containsKey($("transparency"))) {
			transparencyField = new JunVrmlSFFloatField(aDictionary.get($("transparency")));
		}
	}

	/**
	 * Answer the default value of ambientIntensity.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultAmbientIntensity() {
		return 0.2f;
	}

	/**
	 * Answer the default value of diffuse color.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultDiffuseColor() {
		return new float[] { 0.8f, 0.8f, 0.8f };
	}

	/**
	 * Answer the default value of emissive color.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultEmissiveColor() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of shininess.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultShininess() {
		return 0.2f;
	}

	/**
	 * Answer the default value of specular color.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultSpecularColor() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of transparency.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float DefaultTransparency() {
		return 0;
	}

	/**
	 * Answer the ambient intensity.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float ambientIntensity() {
		return this.ambientIntensityField().value();
	}

	/**
	 * Answer the diffuse color.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] diffuseColor() {
		return this.diffuseColorField().value();
	}

	/**
	 * Answer the emissive color.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] emissiveColor() {
		return this.emissiveColorField().value();
	}

	/**
	 * Answer the shininess.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float shininess() {
		return this.shininessField().value();
	}

	/**
	 * Answer the specular color.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] specularColor() {
		return this.specularColorField().value();
	}

	/**
	 * Answer the transparency.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float transparency() {
		return this.transparencyField().value();
	}

	/**
	 * Answer the ambientIntensity field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField ambientIntensityField() {
		if (ambientIntensityField == null) {
			ambientIntensityField = new JunVrmlSFFloatField(DefaultAmbientIntensity());
		}
		return ambientIntensityField;
	}

	/**
	 * Answer the diffuseColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFColorField
	 * @category accessing
	 */
	protected JunVrmlSFColorField diffuseColorField() {
		if (diffuseColorField == null) {
			diffuseColorField = new JunVrmlSFColorField(DefaultDiffuseColor());
		}
		return diffuseColorField;
	}

	/**
	 * Answer the emissiveColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFColorField
	 * @category accessing
	 */
	protected JunVrmlSFColorField emissiveColorField() {
		if (emissiveColorField == null) {
			emissiveColorField = new JunVrmlSFColorField(DefaultEmissiveColor());
		}
		return emissiveColorField;
	}

	/**
	 * Answer the shininess field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField shininessField() {
		if (shininessField == null) {
			shininessField = new JunVrmlSFFloatField(DefaultShininess());
		}
		return shininessField;
	}

	/**
	 * Answer the specularColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlSFColorField
	 * @category accessing
	 */
	protected JunVrmlSFColorField specularColorField() {
		if (specularColorField == null) {
			specularColorField = new JunVrmlSFColorField(DefaultSpecularColor());
		}
		return specularColorField;
	}

	/**
	 * Answer the transparency field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField transparencyField() {
		if (transparencyField == null) {
			transparencyField = new JunVrmlSFFloatField(DefaultTransparency());
		}
		return transparencyField;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doMaterial_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the diffuse color as an instance of Color.
	 * 
	 * @return java.awt.Color
	 * @category code generation
	 */
	public Color diffuseColorAsColor() {
		return this.diffuseColorField().asColor();
	}

	/**
	 * Answer the emissive color as an instance of Color.
	 * 
	 * @return java.awt.Color
	 * @category code generation
	 */
	public Color emissiveColorAsColor() {
		return this.emissiveColorField().asColor();
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		if (emissiveColorField != null) {
			a3dObject.paint_(this.emissiveColorAsColor());
		} else {
			a3dObject.paint_(this.diffuseColorAsColor());
		}

		if (transparencyField != null) {
			a3dObject.alpha_(Math.max(0, Math.min(1 - this.transparency(), 1)));
		}
	}

}
