package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlDirectionalLightNode20 class
 * 
 *  @author    nisinaka
 *  @created   2000/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlDirectionalLightNode20.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlDirectionalLightNode20 extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlSFFloatField ambientIntensityField;
	protected JunVrmlSFColorField colorField;
	protected JunVrmlSFVec3fField directionField;
	protected JunVrmlSFFloatField intensityField;
	protected JunVrmlSFBoolField onField;

	/**
	 * Create a new instance of JunVrmlDirectionalLightNode20 and initialize
	 * it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlDirectionalLightNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("ambientIntensity"))) {
			ambientIntensityField = new JunVrmlSFFloatField(aDictionary.get($("ambientIntensity")));
		}

		if (aDictionary.containsKey($("color"))) {
			colorField = new JunVrmlSFColorField(aDictionary.get($("color")));
		}

		if (aDictionary.containsKey($("direction"))) {
			directionField = new JunVrmlSFVec3fField(aDictionary.get($("direction")));
		}

		if (aDictionary.containsKey($("intensity"))) {
			intensityField = new JunVrmlSFFloatField(aDictionary.get($("intensity")));
		}

		if (aDictionary.containsKey($("on"))) {
			onField = new JunVrmlSFBoolField(aDictionary.get($("on")));
		}
	}

	/**
	 * Answer the default value of ambientIntensity.
	 * 
	 * @return float
	 */
	public static final float DefaultAmbientIntensity() {
		return 0;
	}

	/**
	 * Answer the default value of color.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultColor() {
		return new float[] { 1, 1, 1 };
	}

	/**
	 * Answer the default value of direction.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultDirection() {
		return new float[] { 0, 0, -1 };
	}

	/**
	 * Answer the default value of intensity.
	 * 
	 * @return float
	 */
	public static final float DefaultIntensity() {
		return 1;
	}

	/**
	 * Answer the default value of on.
	 * 
	 * @return boolean
	 */
	public static final boolean DefaultOn() {
		return true;
	}

	/**
	 * Answer the ambient intensity.
	 * 
	 * @return float
	 */
	public float ambientIntensity() {
		return this.ambientIntensityField().value();
	}

	/**
	 * Convert to a JunOpenGLDisplayLight.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight
	 */
	public JunOpenGLDisplayLight asJunOpenGLDisplayLight() {
		return JunOpenGLDisplayLight.ParallelLight_color_direction_(this.on(), this.colorField().asColor(), this.directionAs3dPoint());
	}

	/**
	 * Answer the color.
	 * 
	 * @return float[]
	 */
	public float[] color() {
		return this.colorField().value();
	}

	/**
	 * Answer the direction.
	 * 
	 * @return float[]
	 */
	public float[] direction() {
		return this.directionField().value();
	}

	/**
	 * Answer the direction as a Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint directionAs3dPoint() {
		return this.directionField().as3dPoint();
	}

	/**
	 * Answer the intensity.
	 * 
	 * @return float
	 */
	public float intensity() {
		return this.intensityField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doDirectionalLight_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the on.
	 * 
	 * @return boolean
	 */
	public boolean on() {
		return this.onField().value();
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Answer the ambientIntensity field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField ambientIntensityField() {
		if (ambientIntensityField == null) {
			ambientIntensityField = new JunVrmlSFFloatField(DefaultAmbientIntensity());
		}

		return ambientIntensityField;
	}

	/**
	 * Answer the color field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFColorField
	 */
	protected JunVrmlSFColorField colorField() {
		if (colorField == null) {
			colorField = new JunVrmlSFColorField(DefaultColor());
		}

		return colorField;
	}

	/**
	 * Answer the direction field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 */
	protected JunVrmlSFVec3fField directionField() {
		if (directionField == null) {
			directionField = new JunVrmlSFVec3fField(DefaultDirection());
		}

		return directionField;
	}

	/**
	 * Answer the intensity field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField intensityField() {
		if (intensityField == null) {
			intensityField = new JunVrmlSFFloatField(DefaultIntensity());
		}

		return intensityField;
	}

	/**
	 * Answer the on field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField onField() {
		if (onField == null) {
			onField = new JunVrmlSFBoolField(DefaultOn());
		}

		return onField;
	}
}
