package jp.co.sra.jun.vrml.node.property10;

import java.awt.Image;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;
import jp.co.sra.smalltalk.StSymbol;

/**
 * JunVrmlTexture2Node class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlTexture2Node.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlTexture2Node extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlSFStringField filenameField;
	protected JunVrmlSFImageField imageField;
	protected JunVrmlSFEnumField wrapSField;
	protected JunVrmlSFEnumField wrapTField;

	/**
	 * Create a new instance of JunVrmlTexture2Node and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlTexture2Node(Hashtable aDictionary) {
		if (aDictionary.containsKey($("filename"))) {
			filenameField = new JunVrmlSFStringField(aDictionary.get($("filename")));
		}

		if (aDictionary.containsKey($("image"))) {
			imageField = new JunVrmlSFImageField(aDictionary.get($("image")));
		}

		if (aDictionary.containsKey($("wrapS"))) {
			wrapSField = new JunVrmlSFEnumField(aDictionary.get($("wrapS")));
		}

		if (aDictionary.containsKey($("wrapT"))) {
			wrapTField = new JunVrmlSFEnumField(aDictionary.get($("wrapT")));
		}
	}

	/**
	 * Answer the default value of filename.
	 * 
	 * @return java.lang.String
	 */
	public static final String DefaultFilename() {
		return "";
	}

	/**
	 * Answer the default value of image.
	 * 
	 * @return int[]
	 */
	public static final int[] DefaultImage() {
		return new int[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of wrapS.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public static final StSymbol DefaultWrapS() {
		return $("REPEAT");
	}

	/**
	 * Answer the default value of wrapT.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public static final StSymbol DefaultWrapT() {
		return $("REPEAT");
	}

	/**
	 * Answer the filename.
	 * 
	 * @return java.lang.String
	 */
	public String filename() {
		return this.filenameField().value();
	}

	/**
	 * Answer the image.
	 * 
	 * @return int[]
	 */
	public int[] image() {
		return this.imageField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doTexture2_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		Image anImage = this.imageField().asImage();

		if (anImage != null) {
			a3dObject.texture_(new JunOpenGLTexture(anImage));
		}
	}

	/**
	 * Answer the wrapS value.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol wrapS() {
		return this.wrapSField().value();
	}

	/**
	 * Answer the wrapT value.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol wrapT() {
		return this.wrapSField().value();
	}

	/**
	 * Answer the filename field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField
	 */
	protected JunVrmlSFStringField filenameField() {
		if (filenameField == null) {
			filenameField = new JunVrmlSFStringField(DefaultFilename());
		}

		return filenameField;
	}

	/**
	 * Answer the image field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFImageField
	 */
	protected JunVrmlSFImageField imageField() {
		if (imageField == null) {
			imageField = new JunVrmlSFImageField(DefaultImage());
		}

		return imageField;
	}

	/**
	 * Answer the wrapS field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFEnumField
	 */
	protected JunVrmlSFEnumField wrapSField() {
		if (wrapSField == null) {
			wrapSField = new JunVrmlSFEnumField(DefaultWrapS());
		}

		return wrapSField;
	}

	/**
	 * Answer the wrapT field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFEnumField
	 */
	protected JunVrmlSFEnumField wrapTField() {
		if (wrapTField == null) {
			wrapTField = new JunVrmlSFEnumField(DefaultWrapT());
		}

		return wrapTField;
	}
}
