package jp.co.sra.jun.vrml.node.grouping20;

import java.util.Hashtable;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlAppearanceNode;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlShapeNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlShapeNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlShapeNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGroupingNode {
	protected JunVrmlAppearanceNode appearance;
	protected JunVrmlAbstractGeometryNode geometry;

	/**
	 * Create a new instance of JunVrmlShapeNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlShapeNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("appearance"))) {
			this.appearance_((JunVrmlAppearanceNode) aDictionary.get($("appearance")));
		}

		if (aDictionary.containsKey($("geometry"))) {
			this.geometry_((JunVrmlAbstractGeometryNode) aDictionary.get($("geometry")));
		}
	}

	/**
	 * Answer the appearance node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlAppearanceNode
	 */
	public JunVrmlAppearanceNode appearance() {
		return appearance;
	}

	/**
	 * Set the appearance node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlAppearanceNode
	 */
	public void appearance_(JunVrmlAppearanceNode aNode) {
		appearance = aNode;
	}

	/**
	 * Answer the geometry node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode
	 */
	public JunVrmlAbstractGeometryNode geometry() {
		return geometry;
	}

	/**
	 * Set the geometry node.
	 * 
	 * @param aNode  jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode
	 */
	public void geometry_(JunVrmlAbstractGeometryNode aNode) {
		geometry = aNode;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doShape_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}
}
