package jp.co.sra.jun.vrml.node.geometry20;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode;
import jp.co.sra.jun.vrml.node.property20.*;

/**
 * JunVrmlPointSetNode20 class
 * 
 *  @author    nisinaka
 *  @created   2003/10/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlPointSetNode20.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlPointSetNode20 extends JunVrmlAbstractGeometryNode {

	protected JunVrmlColorNode color;
	protected JunVrmlCoordinateNode coord;

	protected static final float VertexSize = 1;

	/**
	 * Create a new instance of JunVrmlPointSetNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlPointSetNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("color"))) {
			this.color_((JunVrmlColorNode) aDictionary.get($("color")));
		}

		if (aDictionary.containsKey($("coord"))) {
			this.coord_((JunVrmlCoordinateNode) aDictionary.get($("coord")));
		}
	}

	/**
	 * Answer the color node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 * @category accessing
	 */
	public JunVrmlColorNode color() {
		return color;
	}

	/**
	 * Set the color node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 * @category accessing
	 */
	public void color_(JunVrmlColorNode aNode) {
		color = aNode;
	}

	/**
	 * Answer the coord.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 * @category accessing
	 */
	public JunVrmlCoordinateNode coord() {
		return coord;
	}

	/**
	 * Set the coord.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 * @category accessing
	 */
	public void coord_(JunVrmlCoordinateNode aNode) {
		coord = aNode;
	}

	/**
	 * Convert the geometry node as a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode#asJunOpenGL3dObject()
	 * @category code generation
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		if (this.coord() == null) {
			return null;
		}

		Jun3dPoint[] coordinates = this.coord().pointAs3dPoints();
		JunOpenGL3dVertex[] vertexes = new JunOpenGL3dVertex[coordinates.length];
		for (int i = 0; i < coordinates.length; i++) {
			vertexes[i] = new JunOpenGL3dVertex(coordinates[i]);
			vertexes[i].size_(VertexSize);
		}

		this.colorsOn_(vertexes);

		return new JunOpenGL3dCompoundObject(vertexes);
	}

	/**
	 * Set the colors on the array of JunOpenGL3dObject.
	 * 
	 * @param objects jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @category code generation
	 */
	public void colorsOn_(JunOpenGL3dObject[] objects) {
		if (color != null) {
			Color[] colors = color.colorAsColors();
			int maxNumber = Math.min(colors.length, objects.length);
			for (int i = 0; i < maxNumber; i++) {
				objects[i].paint_(colors[i]);
			}
		}
	}

}
