package jp.co.sra.jun.vrml.node.geometry20;

import java.awt.Color;
import java.util.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode;
import jp.co.sra.jun.vrml.node.property.JunVrmlNormalNode;
import jp.co.sra.jun.vrml.node.property20.*;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlIndexedFaceSetNode20 class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlIndexedFaceSetNode20.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlIndexedFaceSetNode20 extends JunVrmlAbstractGeometryNode {

	protected JunVrmlColorNode color;
	protected JunVrmlCoordinateNode coord;
	protected JunVrmlNormalNode normal;
	protected JunVrmlTextureCoordinateNode texCoord;
	protected JunVrmlSFBoolField ccwField;
	protected JunVrmlMFInt32Field colorIndexField;
	protected JunVrmlSFBoolField colorPerVertexField;
	protected JunVrmlSFBoolField convexField;
	protected JunVrmlMFInt32Field coordIndexField;
	protected JunVrmlSFFloatField creaseAngleField;
	protected JunVrmlMFInt32Field normalIndexField;
	protected JunVrmlSFBoolField normalPerVertexField;
	protected JunVrmlSFBoolField solidField;
	protected JunVrmlMFInt32Field texCoordIndexField;

	/**
	 * Create a new instance of JunVrmlIndexedFaceSetNode20 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlIndexedFaceSetNode20(Hashtable aDictionary) {
		if (aDictionary.containsKey($("color"))) {
			this.color_((JunVrmlColorNode) aDictionary.get($("color")));
		}

		if (aDictionary.containsKey($("coord"))) {
			this.coord_((JunVrmlCoordinateNode) aDictionary.get($("coord")));
		}

		if (aDictionary.containsKey($("normal"))) {
			this.normal_((JunVrmlNormalNode) aDictionary.get($("normal")));
		}

		if (aDictionary.containsKey($("texCoord"))) {
			this.texCoord_((JunVrmlTextureCoordinateNode) aDictionary.get($("texCoord")));
		}

		//
		if (aDictionary.containsKey($("ccw"))) {
			ccwField = new JunVrmlSFBoolField(aDictionary.get($("ccw")));
		}

		if (aDictionary.containsKey($("colorIndex"))) {
			colorIndexField = new JunVrmlMFInt32Field(aDictionary.get($("colorIndex")));
		}

		if (aDictionary.containsKey($("colorPerVertex"))) {
			colorPerVertexField = new JunVrmlSFBoolField(aDictionary.get($("colorPerVertex")));
		}

		if (aDictionary.containsKey($("convex"))) {
			convexField = new JunVrmlSFBoolField(aDictionary.get($("convex")));
		}

		if (aDictionary.containsKey($("coordIndex"))) {
			coordIndexField = new JunVrmlMFInt32Field(aDictionary.get($("coordIndex")));
		}

		if (aDictionary.containsKey($("creaseAngle"))) {
			creaseAngleField = new JunVrmlSFFloatField(aDictionary.get($("creaseAngle")));
		}

		if (aDictionary.containsKey($("normalIndex"))) {
			normalIndexField = new JunVrmlMFInt32Field(aDictionary.get($("normalIndex")));
		}

		if (aDictionary.containsKey($("normalPerVertex"))) {
			normalPerVertexField = new JunVrmlSFBoolField(aDictionary.get($("normalPerVertex")));
		}

		if (aDictionary.containsKey($("solid"))) {
			solidField = new JunVrmlSFBoolField(aDictionary.get($("solid")));
		}

		if (aDictionary.containsKey($("texCoordIndex"))) {
			texCoordIndexField = new JunVrmlMFInt32Field(aDictionary.get($("texCoordIndex")));
		}
	}

	/**
	 * Answer the default value of ccw.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultCcw() {
		return true;
	}

	/**
	 * Answer the default value of colorIndex.
	 * 
	 * @return int[]
	 * @category Defaults
	 */
	public static final int[] DefaultColorIndex() {
		return new int[] {
		};
	}

	/**
	 * Answer the default value of colorPerVertex.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultColorPerVertex() {
		return true;
	}

	/**
	 * Answer the default value of convex.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultConvex() {
		return true;
	}

	/**
	 * Answer the default value of coordIndex.
	 * 
	 * @return int[]
	 * @category Defaults
	 */
	public static final int[] DefaultCoordIndex() {
		return new int[] {
		};
	}

	/**
	 * Answer the default value of creaseAngle.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultCreaseAngle() {
		return 0;
	}

	/**
	 * Answer the default value of normalIndex.
	 * 
	 * @return int[]
	 * @category Defaults
	 */
	public static final int[] DefaultNormalIndex() {
		return new int[] {
		};
	}

	/**
	 * Answer the default value of normalPerVertex.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultNormalPerVertex() {
		return true;
	}

	/**
	 * Answer the default value of solid.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultSolid() {
		return true;
	}

	/**
	 * Answer the default value of texCoordIndex.
	 * 
	 * @return int[]
	 * @category Defaults
	 */
	public static final int[] DefaultTexCoordIndex() {
		return new int[] {
		};
	}

	/**
	 * Answer the ccw.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean ccw() {
		return this.ccwField().value();
	}

	/**
	 * Answer the color node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 * @category accessing
	 */
	public JunVrmlColorNode color() {
		return color;
	}

	/**
	 * Set the color node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlColorNode
	 * @category accessing
	 */
	public void color_(JunVrmlColorNode aNode) {
		color = aNode;
	}

	/**
	 * Answer the colorIndex.
	 * 
	 * @return int[]
	 * @category accessing
	 */
	public int[] colorIndex() {
		return this.colorIndexField().value();
	}

	/**
	 * Answer the colorPerVertex.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean colorPerVertex() {
		return this.colorPerVertexField().value();
	}

	/**
	 * Answer the convex.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean convex() {
		return this.convexField().value();
	}

	/**
	 * Answer the coord.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 * @category accessing
	 */
	public JunVrmlCoordinateNode coord() {
		return coord;
	}

	/**
	 * Set the coord.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property20.JunVrmlCoordinateNode
	 * @category accessing
	 */
	public void coord_(JunVrmlCoordinateNode aNode) {
		coord = aNode;
	}

	/**
	 * Answer the coordIndex.
	 * 
	 * @return int[]
	 * @category accessing
	 */
	public int[] coordIndex() {
		return this.coordIndexField().value();
	}

	/**
	 * Answer the creaseAngle.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float creaseAngle() {
		return this.creaseAngleField().value();
	}

	/**
	 * Answer the normal.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property.JunVrmlNormalNode
	 * @category accessing
	 */
	public JunVrmlNormalNode normal() {
		return normal;
	}

	/**
	 * Set the normal.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.property.JunVrmlNormalNode
	 * @category accessing
	 */
	public void normal_(JunVrmlNormalNode aNode) {
		normal = aNode;
	}

	/**
	 * Answer the normalIndex.
	 * 
	 * @return int[]
	 * @category accessing
	 */
	public int[] normalIndex() {
		return this.normalIndexField().value();
	}

	/**
	 * Answer the normalPerVertex.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean normalPerVertex() {
		return this.normalPerVertexField().value();
	}

	/**
	 * Answer the solid.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean solid() {
		return this.solidField().value();
	}

	/**
	 * Answer the texCoord.
	 * 
	 * @return jp.co.sra.jun.vrml.property20.JunVrmlTextureCoordinateNode
	 * @category accessing
	 */
	public JunVrmlTextureCoordinateNode texCoord() {
		return texCoord;
	}

	/**
	 * Set the texCoord.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.property20.JunVrmlTextureCoordinateNode
	 * @category accessing
	 */
	public void texCoord_(JunVrmlTextureCoordinateNode aNode) {
		texCoord = aNode;
	}

	/**
	 * Answer the texCoordIndex.
	 * 
	 * @return int[]
	 * @category accessing
	 */
	public int[] texCoordIndex() {
		return this.texCoordIndexField().value();
	}

	/**
	 * Answer the ccw field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField ccwField() {
		if (ccwField == null) {
			ccwField = new JunVrmlSFBoolField(DefaultCcw());
		}
		return ccwField;
	}

	/**
	 * Answer the colorIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 * @category accessing
	 */
	protected JunVrmlMFInt32Field colorIndexField() {
		if (colorIndexField == null) {
			colorIndexField = new JunVrmlMFInt32Field(DefaultColorIndex());
		}
		return colorIndexField;
	}

	/**
	 * Answer the colorPerVertex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField colorPerVertexField() {
		if (colorPerVertexField == null) {
			colorPerVertexField = new JunVrmlSFBoolField(DefaultColorPerVertex());
		}
		return colorPerVertexField;
	}

	/**
	 * Answer the convex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField convexField() {
		if (convexField == null) {
			convexField = new JunVrmlSFBoolField(DefaultConvex());
		}
		return convexField;
	}

	/**
	 * Answer the coordIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 * @category accessing
	 */
	protected JunVrmlMFInt32Field coordIndexField() {
		if (coordIndexField == null) {
			coordIndexField = new JunVrmlMFInt32Field(DefaultCoordIndex());
		}
		return coordIndexField;
	}

	/**
	 * Answer the creaseAngle field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField creaseAngleField() {
		if (creaseAngleField == null) {
			creaseAngleField = new JunVrmlSFFloatField(DefaultCreaseAngle());
		}
		return creaseAngleField;
	}

	/**
	 * Answer the normalIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 * @category accessing
	 */
	protected JunVrmlMFInt32Field normalIndexField() {
		if (normalIndexField == null) {
			normalIndexField = new JunVrmlMFInt32Field(DefaultNormalIndex());
		}
		return normalIndexField;
	}

	/**
	 * Answer the normalPerVertex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField normalPerVertexField() {
		if (normalPerVertexField == null) {
			normalPerVertexField = new JunVrmlSFBoolField(DefaultNormalPerVertex());
		}
		return normalPerVertexField;
	}

	/**
	 * Answer the solid field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField solidField() {
		if (solidField == null) {
			solidField = new JunVrmlSFBoolField(DefaultNormalPerVertex());
		}
		return solidField;
	}

	/**
	 * Answer the texCoordIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFInt32Field
	 * @category accessing
	 */
	protected JunVrmlMFInt32Field texCoordIndexField() {
		if (texCoordIndexField == null) {
			texCoordIndexField = new JunVrmlMFInt32Field(DefaultTexCoordIndex());
		}
		return texCoordIndexField;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doIndexedFaceSet_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		if (this.coord() == null) {
			return null;
		}

		int[][] pointArray = this.coordIndexAsPointArray();
		JunOpenGL3dPolygon[] objects = new JunOpenGL3dPolygon[pointArray.length];
		Jun3dPoint[] coordinates = this.coord().pointAs3dPoints();
		for (int i = 0; i < pointArray.length; i++) {
			int[] indexes = pointArray[i];
			Jun3dPoint[] vertexes = new Jun3dPoint[indexes.length];
			for (int j = 0; j < indexes.length; j++) {
				vertexes[j] = coordinates[indexes[j]];
			}
			objects[i] = new JunOpenGL3dPolygon(vertexes);
		}

		this.colorsOn_(objects);
		this.normalsOn_(objects);

		return new JunOpenGL3dPatchedObject(objects);
	}

	/**
	 * Answer the point array of the colorIndex.
	 * 
	 * @return int[][]
	 * @category code generation
	 */
	public int[][] colorIndexAsPointArray() {
		return this.colorIndexField().asPointArray();
	}

	/**
	 * Answer the point array of the colorIndex.
	 * 
	 * @return int[][]
	 * @category code generation
	 */
	public int[][] normalIndexAsPointArray() {
		return this.normalIndexField().asPointArray();
	}

	/**
	 * Answer the point array of the coordIndex.
	 * 
	 * @return int[][]
	 * @category code generation
	 */
	public int[][] coordIndexAsPointArray() {
		return this.coordIndexField().asPointArray();
	}

	/**
	 * Answer the point array of the texCoordIndex.
	 * 
	 * @return int[][]
	 * @category code generation
	 */
	public int[][] texCoordIndexAsPointArray() {
		return this.texCoordIndexField().asPointArray();
	}

	/**
	 * Set the colors on the array of JunOpenGL3dObject.
	 * 
	 * @param objects jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @category code generation
	 */
	public void colorsOn_(JunOpenGL3dObject[] objects) {
		if (color != null) {
			Color[] colors = color.colorAsColors();
			int[] colorIndex = this.colorIndex();
			if (this.colorPerVertex()) {
				int[][] pointArray = (colorIndex.length > 0) ? this.colorIndexAsPointArray() : this.coordIndexAsPointArray();
				for (int i = 0; i < objects.length; i++) {
					int[] indexes = pointArray[i];
					Color[] anArrayOfColors = new Color[indexes.length];
					for (int j = 0; j < indexes.length; j++) {
						anArrayOfColors[j] = colors[indexes[j]];
					}
					((JunOpenGL3dVertexesObject) objects[i]).colors_(anArrayOfColors);
				}
			} else {
				if (colorIndex.length > 0) {
					for (int i = 0; i < objects.length; i++) {
						objects[i].paint_(colors[colorIndex[i]]);
					}
				} else {
					for (int i = 0; i < objects.length; i++) {
						objects[i].paint_(colors[i]);
					}
				}
			}
		}
	}

	/**
	 * Set the normal vectors on the array of JunOpenGL3dObject.
	 * 
	 * @param objects jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @category code generation
	 */
	public void normalsOn_(JunOpenGL3dObject[] objects) {
		if (normal != null) {
			Jun3dPoint[] vectors = normal.vectorAs3dPoints();
			int[] normalIndex = this.normalIndex();
			if (this.normalPerVertex()) {
				int[][] pointArray = (normalIndex.length > 0) ? this.normalIndexAsPointArray() : this.coordIndexAsPointArray();
				for (int i = 0; i < objects.length; i++) {
					int[] indexes = pointArray[i];
					Jun3dPoint[] anArrayOfVectors = new Jun3dPoint[indexes.length];
					for (int j = 0; j < indexes.length; j++) {
						anArrayOfVectors[j] = vectors[indexes[j]];
					}
					((JunOpenGL3dVertexesObject) objects[i]).normalVectors_(anArrayOfVectors);
				}
			} else {
				if (normalIndex.length > 0) {
					for (int i = 0; i < objects.length; i++) {
						((JunOpenGL3dVertexesObject) objects[i]).normalVector_(vectors[normalIndex[i]]);
					}
				} else {
					for (int i = 0; i < objects.length; i++) {
						((JunOpenGL3dVertexesObject) objects[i]).normalVector_(vectors[i]);
					}
				}
			}
		}
	}

	/**
	 * Set the texture coordinates on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public void texCoordOn_(JunOpenGL3dObject a3dObject) {
		if (this.texCoord() == null) {
			return;
		}

		Vector coordinates = new Vector();
		Jun2dPoint[] texCoord = this.texCoord().pointAs2dPoints();
		int[][] pointArray = this.texCoordIndexAsPointArray();
		for (int i = 0; i < pointArray.length; i++) {
			int[] indexes = pointArray[i];
			for (int j = 0; j < indexes.length; j++) {
				coordinates.addElement(texCoord[indexes[j]]);
			}
		}
		Jun2dPoint[] theCoordinates = new Jun2dPoint[coordinates.size()];
		coordinates.copyInto(theCoordinates);
		a3dObject.texture().coordinates_(theCoordinates);
	}

}
