package jp.co.sra.jun.vrml.node.geometry20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCone;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlConeNode class
 * 
 *  @author    nisinaka
 *  @created   2000/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlConeNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlConeNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode {
	protected JunVrmlSFFloatField bottomRadiusField;
	protected JunVrmlSFFloatField heightField;
	protected JunVrmlSFBoolField sideField;
	protected JunVrmlSFBoolField bottomField;

	/**
	 * Create a new instance of JunVrmlConeNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlConeNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("bottomRadius"))) {
			bottomRadiusField = new JunVrmlSFFloatField(aDictionary.get($("bottomRadius")));
		}

		if (aDictionary.containsKey($("height"))) {
			heightField = new JunVrmlSFFloatField(aDictionary.get($("height")));
		}

		if (aDictionary.containsKey($("side"))) {
			sideField = new JunVrmlSFBoolField(aDictionary.get($("side")));
		}

		if (aDictionary.containsKey($("bottom"))) {
			bottomField = new JunVrmlSFBoolField(aDictionary.get($("bottom")));
		}
	}

	/**
	 * Answer the default value of bottom.
	 * 
	 * @return boolean
	 */
	public static final boolean DefaultBottom() {
		return true;
	}

	/**
	 * Answer the default value of bottomRadius.
	 * 
	 * @return float
	 */
	public static final float DefaultBottomRadius() {
		return 1;
	}

	/**
	 * Answer the default value of height.
	 * 
	 * @return float
	 */
	public static final float DefaultHeight() {
		return 2;
	}

	/**
	 * Answer the default value of side.
	 * 
	 * @return boolean
	 */
	public static final boolean DefaultSide() {
		return true;
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return new JunOpenGL3dCone(this.bottomRadius(), this.height());
	}

	/**
	 * Answer the bottom.
	 * 
	 * @return boolean
	 */
	public boolean bottom() {
		return this.bottomField().value();
	}

	/**
	 * Answer the bottomRadius.
	 * 
	 * @return float
	 */
	public float bottomRadius() {
		return this.bottomRadiusField().value();
	}

	/**
	 * Answer the height.
	 * 
	 * @return float
	 */
	public float height() {
		return this.heightField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doCone_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the side.
	 * 
	 * @return boolean
	 */
	public boolean side() {
		return this.sideField().value();
	}

	/**
	 * Answer the bottom field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField bottomField() {
		if (bottomField == null) {
			bottomField = new JunVrmlSFBoolField(DefaultBottom());
		}

		return bottomField;
	}

	/**
	 * Answer the bottomRadius.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField bottomRadiusField() {
		if (bottomRadiusField == null) {
			bottomRadiusField = new JunVrmlSFFloatField(DefaultBottomRadius());
		}

		return bottomRadiusField;
	}

	/**
	 * Answer the height.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 */
	protected JunVrmlSFFloatField heightField() {
		if (heightField == null) {
			heightField = new JunVrmlSFFloatField(DefaultHeight());
		}

		return heightField;
	}

	/**
	 * Answer the side field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 */
	protected JunVrmlSFBoolField sideField() {
		if (sideField == null) {
			sideField = new JunVrmlSFBoolField(DefaultSide());
		}

		return sideField;
	}
}
