package jp.co.sra.jun.vrml.node.geometry10;

import java.util.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFLongField;
import jp.co.sra.jun.vrml.node.abstracts.*;
import jp.co.sra.jun.vrml.node.property10.*;
import jp.co.sra.jun.vrml.support.*;
import jp.co.sra.smalltalk.SmalltalkException;

/**
 * JunVrmlIndexedFaceSetNode10 class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlIndexedFaceSetNode10.java,v 8.10 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlIndexedFaceSetNode10 extends JunVrmlAbstractGeometryNode {
	protected JunVrmlMFLongField coordIndexField;
	protected JunVrmlMFLongField materialIndexField;
	protected JunVrmlMFLongField normalIndexField;
	protected JunVrmlMFLongField textureCoordIndexField;

	/**
	 * Create a new instance of JunVrmlIndexedFaceSetNode10 and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlIndexedFaceSetNode10(Hashtable aDictionary) {
		if (aDictionary.containsKey($("coordIndex"))) {
			coordIndexField = new JunVrmlMFLongField(aDictionary.get($("coordIndex")));
		}

		if (aDictionary.containsKey($("materialIndex"))) {
			materialIndexField = new JunVrmlMFLongField(aDictionary.get($("materialIndex")));
		}

		if (aDictionary.containsKey($("normalIndex"))) {
			normalIndexField = new JunVrmlMFLongField(aDictionary.get($("normalIndex")));
		}

		if (aDictionary.containsKey($("textureCoordIndex"))) {
			textureCoordIndexField = new JunVrmlMFLongField(aDictionary.get($("textureCoordIndex")));
		}
	}

	/**
	 * Answer the default value of coordIndex.
	 * 
	 * @return long[]
	 */
	public static final long[] DefaultCoordIndex() {
		return new long[] { 0 };
	}

	/**
	 * Answer the default value of materialIndex.
	 * 
	 * @return long[]
	 */
	public static final long[] DefaultMaterialIndex() {
		return new long[] { -1 };
	}

	/**
	 * Answer the default value of normalIndex.
	 * 
	 * @return long[]
	 */
	public static final long[] DefaultNormalIndex() {
		return new long[] { -1 };
	}

	/**
	 * Answer the default value of textureCoordIndex.
	 * 
	 * @return long[]
	 */
	public static final long[] DefaultTextureCoordIndex() {
		return new long[] { -1 };
	}

	/**
	 * Convert the geometry node as a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * 
	 * @throws SmalltalkException DOCUMENT ME!
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		throw new SmalltalkException("Use 'asJunOpenGL3dObjectWithCoordinate3_'");
	}

	/**
	 * Convert the geometry node as a JunOpenGL3dObject.
	 * 
	 * @param aCoordinate3Node
	 *        jp.co.sra.jun.vrml.node.property10.JunVrmlCoordinate3Node
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObjectWithCoordinate3_(JunVrmlCoordinate3Node aCoordinate3Node) {
		long[][] pointArray = this.coordIndexAsPointArray();
		JunOpenGL3dObject[] objects = new JunOpenGL3dObject[pointArray.length];
		Jun3dPoint[] coordinates = aCoordinate3Node.pointAs3dPoints();

		for (int i = 0; i < pointArray.length; i++) {
			long[] indexes = pointArray[i];
			Jun3dPoint[] vertexes = new Jun3dPoint[indexes.length];

			for (int j = 0; j < indexes.length; j++) {
				vertexes[j] = coordinates[(int) indexes[j]];
			}

			objects[i] = new JunOpenGL3dPolygon(vertexes);
		}

		if (objects.length == 0) {
			return null;
		}

		if (objects.length == 1) {
			return (JunOpenGL3dObject) objects[0];
		}

		return new JunOpenGL3dCompoundObject(objects);
	}

	/**
	 * Answer the coordIndex.
	 * 
	 * @return long[]
	 */
	public long[] coordIndex() {
		return this.coordIndexField().value();
	}

	/**
	 * Answer the point array of coordIndex.
	 * 
	 * @return long[][]
	 */
	public long[][] coordIndexAsPointArray() {
		return this.coordIndexField().asPointArray();
	}

	/**
	 * Answer the materialIndex.
	 * 
	 * @return long[]
	 */
	public long[] materialIndex() {
		return this.materialIndexField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doIndexedFaceSet_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the normalIndex.
	 * 
	 * @return long[]
	 */
	public long[] normalIndex() {
		return this.normalIndexField().value();
	}

	/**
	 * Set the texture coordinates on the 3D object.
	 * 
	 * @param aTextureCoordinate2Node
	 *        jp.co.sra.jun.vrml.node.property10.JunVrmlTextureCoordinate2Node
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void textureCoordinate_on_(JunVrmlTextureCoordinate2Node aTextureCoordinate2Node, JunOpenGL3dObject a3dObject) {
		Vector coordinates = new Vector();
		Jun2dPoint[] textureCoordinates2 = aTextureCoordinate2Node.pointAs2dPoints();
		long[][] pointArray = this.textureCoordIndexAsPointArray();

		for (int i = 0; i < pointArray.length; i++) {
			long[] indexes = pointArray[i];

			for (int j = 0; j < indexes.length; j++) {
				coordinates.addElement(textureCoordinates2[(int) indexes[j]]);
			}
		}

		Jun2dPoint[] theCoordinates = new Jun2dPoint[coordinates.size()];
		coordinates.copyInto(theCoordinates);
		a3dObject.texture().coordinates_(theCoordinates);
	}

	/**
	 * Answer the textureCoordIndex.
	 * 
	 * @return long[]
	 */
	public long[] textureCoordIndex() {
		return this.textureCoordIndexField().value();
	}

	/**
	 * Answer the point array of textureCoordIndex.
	 * 
	 * @return long[][]
	 */
	public long[][] textureCoordIndexAsPointArray() {
		return this.textureCoordIndexField().asPointArray();
	}

	/**
	 * Answer the coordIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFLongField
	 */
	protected JunVrmlMFLongField coordIndexField() {
		if (coordIndexField == null) {
			coordIndexField = new JunVrmlMFLongField(DefaultCoordIndex());
		}

		return coordIndexField;
	}

	/**
	 * Answer the materialIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFLongField
	 */
	protected JunVrmlMFLongField materialIndexField() {
		if (materialIndexField == null) {
			materialIndexField = new JunVrmlMFLongField(DefaultCoordIndex());
		}

		return materialIndexField;
	}

	/**
	 * Answer the materialIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFLongField
	 */
	protected JunVrmlMFLongField normalIndexField() {
		if (normalIndexField == null) {
			normalIndexField = new JunVrmlMFLongField(DefaultCoordIndex());
		}

		return normalIndexField;
	}

	/**
	 * Answer the textureCoordIndex field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFLongField
	 */
	protected JunVrmlMFLongField textureCoordIndexField() {
		if (textureCoordIndexField == null) {
			textureCoordIndexField = new JunVrmlMFLongField(DefaultCoordIndex());
		}

		return textureCoordIndexField;
	}
}
