package jp.co.sra.jun.vrml.field.sf;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * JunVrmlSFRotationField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSFRotationField.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlSFRotationField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlSFField {
	protected float[] value;

	/**
	 * Create a new instance of JunVrmlSFRotationField and initialize it.
	 * 
	 * @param numbers float[]
	 */
	public JunVrmlSFRotationField(float[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlSFRotationField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlSFRotationField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlSFRotationField and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlSFRotationField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert the value to a Jun3dTransformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	public Jun3dTransformation as3dTransformation() {
		Jun3dPoint aPoint = new Jun3dPoint(value[0], value[1], value[2]);
		JunAngle anAngle = JunAngle.FromRad_(value[3]);

		return Jun3dTransformation.Rotate_around_(anAngle, new Jun3dLine(Jun3dPoint.Zero(), aPoint));
	}

	/**
	 * Convert the value to a reversed Jun3dTransformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	public Jun3dTransformation asReverse3dTransformation() {
		Jun3dPoint aPoint = new Jun3dPoint(value[0], value[1], value[2]);
		JunAngle anAngle = JunAngle.FromRad_(value[3] * -1);

		return Jun3dTransformation.Rotate_around_(anAngle, new Jun3dLine(Jun3dPoint.Zero(), aPoint));
	}

	/**
	 * Answer my value.
	 * 
	 * @return float[]
	 */
	public float[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers float[]
	 */
	public void value_(float[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new float[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].floatValue();
		}
	}
}
