package jp.co.sra.jun.vrml.field.sf;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;

/**
 * JunVrmlSFImageField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @updated   2004/12/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSFImageField.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlSFImageField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlSFField {

	protected int[] value;

	/**
	 * Create a new instance of JunVrmlSFImageField and initialize it.
	 * 
	 * @param numbers int[]
	 */
	public JunVrmlSFImageField(int[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlSFImageField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlSFImageField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlSFImageField and initialize it.
	 * 
	 * @param aVector java.utilVector
	 */
	public JunVrmlSFImageField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert to an Image.
	 * 
	 * @return java.awt.Image
	 */
	public Image asImage() {
		int type = value[2];
		if (type == 0) {
			return null;
		}
		if (type != 3) {
			this.error_("The type of image is not supported");
			return null;
		}

		int width = value[0];
		int height = value[1];
		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				int i = (height - y - 1) * width + x + 3;
				image.setRGB(x, y, value[i]);
			}
		}
		return image;
	}

	/**
	 * Answer my value.
	 * 
	 * @return int[]
	 */
	public int[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers int[]
	 */
	public void value_(int[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new int[numbers.length];
		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].intValue();
		}
	}
}
