package jp.co.sra.jun.vrml.field.sf;

import java.awt.Color;
import java.util.Vector;

/**
 * JunVrmlSFColorField class
 * 
 *  @author    nisinaka
 *  @created   2000/03/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSFColorField.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlSFColorField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlSFField {
	protected float[] value;

	/**
	 * Create a new instance of JunVrmlSFColorField and initialize it.
	 * 
	 * @param numbers float[]
	 */
	public JunVrmlSFColorField(float[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlSFColorField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlSFColorField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlSFColorField and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlSFColorField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert to a Color.
	 * 
	 * @return java.awt.Color
	 */
	public Color asColor() {
		return new Color(value[0], value[1], value[2]);
	}

	/**
	 * Answer my value.
	 * 
	 * @return float[]
	 */
	public float[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers float[]
	 */
	public void value_(float[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new float[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].floatValue();
		}
	}
}
